/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.oneway;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQAsyncSendProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OneWaySendWithMQIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TagMessageWith1ConsumerIT.class);
    private static boolean sendFail = false;
    private RMQAsyncSendProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = OneWaySendWithMQIT.initTopic();
        logger.info(String.format("user topic[%s]!", this.topic));
        this.producer = OneWaySendWithMQIT.getAsyncProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testAsyncSendWithMQ() {
        int msgSize = 20;
        int queueId = 0;
        RMQNormalConsumer consumer = OneWaySendWithMQIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
        MessageQueue mq = new MessageQueue(this.topic, BROKER1_NAME, queueId);
        this.producer.sendOneWay(msgSize, mq);
        this.producer.waitForResponse(5000);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

