/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.oneway;

import java.util.List;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.factory.ProducerFactory;
import org.apache.rocketmq.test.util.RandomUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OneWaySendExceptionIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TagMessageWith1ConsumerIT.class);
    private static boolean sendFail = false;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = OneWaySendExceptionIT.initTopic();
        logger.info(String.format("user topic[%s]!", this.topic));
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test(expected=NullPointerException.class)
    public void testSendMQNull() throws Exception {
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        MessageQueue messageQueue = null;
        producer.sendOneway(msg, messageQueue);
    }

    @Test(expected=MQClientException.class)
    public void testSendSelectorNull() throws Exception {
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        MessageQueueSelector selector = null;
        producer.sendOneway(msg, selector, (Object)100);
    }

    @Test(expected=MQClientException.class)
    public void testSelectorThrowsException() throws Exception {
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        producer.sendOneway(msg, new MessageQueueSelector(){

            public MessageQueue select(List<MessageQueue> list, Message message, Object o) {
                String str = null;
                return list.get(str.length());
            }
        }, null);
    }
}

