/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.exception.producer;

import com.google.common.truth.Truth;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.util.RandomUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ProducerGroupAndInstanceNameValidityIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(ProducerGroupAndInstanceNameValidityIT.class);
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = ProducerGroupAndInstanceNameValidityIT.initTopic();
        logger.info(String.format("use topic: %s !", this.topic));
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testTwoProducerSameGroupAndInstanceName() {
        RMQNormalProducer producer1 = ProducerGroupAndInstanceNameValidityIT.getProducer(NAMESRV_ADDR, this.topic);
        Truth.assertThat((Boolean)producer1.isStartSuccess()).isEqualTo((Object)true);
        RMQNormalProducer producer2 = ProducerGroupAndInstanceNameValidityIT.getProducer(NAMESRV_ADDR, this.topic, producer1.getProducerGroupName(), producer1.getProducerInstanceName());
        Truth.assertThat((Boolean)producer2.isStartSuccess()).isEqualTo((Object)false);
    }

    @Test
    public void testTwoProducerSameGroup() {
        RMQNormalProducer producer1 = ProducerGroupAndInstanceNameValidityIT.getProducer(NAMESRV_ADDR, this.topic);
        Truth.assertThat((Boolean)producer1.isStartSuccess()).isEqualTo((Object)true);
        RMQNormalProducer producer2 = ProducerGroupAndInstanceNameValidityIT.getProducer(NAMESRV_ADDR, this.topic, producer1.getProducerGroupName(), RandomUtils.getStringByUUID());
        Truth.assertThat((Boolean)producer2.isStartSuccess()).isEqualTo((Object)true);
    }
}

