/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.exception.msg;

import com.google.common.truth.Truth;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.balance.NormalMsgStaticBalanceIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MessageFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MessageUserPropIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(NormalMsgStaticBalanceIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = MessageUserPropIT.initTopic();
        logger.info(String.format("use topic: %s !", this.topic));
        this.producer = MessageUserPropIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSendEnglishUserProp() {
        Message msg = MessageFactory.getRandomMessage((String)this.topic);
        String msgKey = "jueyinKey";
        String msgValue = "jueyinValue";
        msg.putUserProperty(msgKey, msgValue);
        RMQNormalConsumer consumer = MessageUserPropIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
        this.producer.send((Object)msg, null);
        Truth.assertThat((Integer)this.producer.getAllMsgBody().size()).isEqualTo((Object)1);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Message sendMsg = (Message)this.producer.getFirstMsg();
        Message recvMsg = (Message)consumer.getListener().getFirstMsg();
        Truth.assertThat((String)recvMsg.getUserProperty(msgKey)).isEqualTo((Object)sendMsg.getUserProperty(msgKey));
    }

    @Test
    public void testSendChinaUserProp() {
        Message msg = MessageFactory.getRandomMessage((String)this.topic);
        String msgKey = "jueyinKey";
        String msgValue = "jueyinzhi";
        msg.putUserProperty(msgKey, msgValue);
        RMQNormalConsumer consumer = MessageUserPropIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
        this.producer.send((Object)msg, null);
        Truth.assertThat((Integer)this.producer.getAllMsgBody().size()).isEqualTo((Object)1);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Message sendMsg = (Message)this.producer.getFirstMsg();
        Message recvMsg = (Message)consumer.getListener().getFirstMsg();
        Truth.assertThat((String)recvMsg.getUserProperty(msgKey)).isEqualTo((Object)sendMsg.getUserProperty(msgKey));
    }
}

