/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.exception.msg;

import com.google.common.truth.Truth;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.factory.MessageFactory;
import org.apache.rocketmq.test.factory.ProducerFactory;
import org.apache.rocketmq.test.util.RandomUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MessageExceptionIT
extends BaseConf {
    private static DefaultMQProducer producer = null;
    private static String topic = null;

    @Before
    public void setUp() {
        producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        topic = MessageExceptionIT.initTopic();
    }

    @After
    public void tearDown() {
        producer.shutdown();
    }

    @Test
    public void testProducerSmoke() {
        Message msg = new Message(topic, RandomUtils.getStringByUUID().getBytes());
        SendResult sendResult = null;
        try {
            sendResult = producer.send(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat((Object)sendResult).isNotEqualTo(null);
        Truth.assertThat((Comparable)sendResult.getSendStatus()).isEqualTo((Object)SendStatus.SEND_OK);
    }

    @Test(expected=NullPointerException.class)
    public void testSynSendNullMessage() throws Exception {
        producer.send((Message)null);
    }

    @Test(expected=MQClientException.class)
    public void testSynSendNullBodyMessage() throws Exception {
        Message msg = new Message(topic, RandomUtils.getStringByUUID().getBytes());
        msg.setBody(null);
        producer.send(msg);
    }

    @Test(expected=MQClientException.class)
    public void testSynSendZeroSizeBodyMessage() throws Exception {
        Message msg = new Message(topic, RandomUtils.getStringByUUID().getBytes());
        msg.setBody(new byte[0]);
        producer.send(msg);
    }

    @Test(expected=MQClientException.class)
    public void testSynSendOutOfSizeBodyMessage() throws Exception {
        Message msg = new Message(topic, RandomUtils.getStringByUUID().getBytes());
        msg.setBody(new byte[0x400001]);
        producer.send(msg);
    }

    @Test(expected=MQClientException.class)
    public void testSynSendNullTopicMessage() throws Exception {
        Message msg = new Message(null, RandomUtils.getStringByUUID().getBytes());
        producer.send(msg);
    }

    @Test(expected=MQClientException.class)
    public void testSynSendBlankTopicMessage() throws Exception {
        Message msg = new Message("", RandomUtils.getStringByUUID().getBytes());
        producer.send(msg);
    }

    @Test(expected=MQClientException.class)
    public void testSend128kMsg() throws Exception {
        Message msg = new Message(topic, RandomUtils.getStringWithNumber((int)0x400001).getBytes());
        producer.send(msg);
    }

    @Test
    public void testSendLess128kMsg() {
        Message msg = new Message(topic, RandomUtils.getStringWithNumber((int)131072).getBytes());
        SendResult sendResult = null;
        try {
            sendResult = producer.send(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat((Comparable)sendResult.getSendStatus()).isEqualTo((Object)SendStatus.SEND_OK);
    }

    @Test
    public void testSendMsgWithUserProperty() {
        Message msg = MessageFactory.getRandomMessage((String)topic);
        msg.putUserProperty("key", RandomUtils.getCheseWord((int)10240));
        SendResult sendResult = null;
        try {
            sendResult = producer.send(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Truth.assertThat((Comparable)sendResult.getSendStatus()).isEqualTo((Object)SendStatus.SEND_OK);
    }
}

