/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.async;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQAsyncSendProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AsyncSendWithMessageQueueSelectorIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQAsyncSendProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = AsyncSendWithMessageQueueSelectorIT.initTopic();
        logger.info(String.format("user topic[%s]!", this.topic));
        this.producer = AsyncSendWithMessageQueueSelectorIT.getAsyncProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSendWithSelector() {
        int msgSize = 20;
        boolean queueId = false;
        RMQNormalConsumer consumer = AsyncSendWithMessageQueueSelectorIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
        this.producer.asyncSend(msgSize, new MessageQueueSelector(){

            public MessageQueue select(List<MessageQueue> list, Message message, Object o) {
                for (MessageQueue mq : list) {
                    if (mq.getQueueId() != 0 || !mq.getBrokerName().equals(BROKER1_NAME)) continue;
                    return mq;
                }
                return list.get(0);
            }
        });
        this.producer.waitForResponse(5000);
        Truth.assertThat((Integer)this.producer.getSuccessMsgCount()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        VerifyUtils.verifyMessageQueueId((int)0, (Collection)consumer.getListener().getAllOriginMsg());
        this.producer.clearMsg();
        consumer.clearMsg();
        this.producer.getSuccessSendResult().clear();
        this.producer.asyncSend(msgSize, new MessageQueueSelector(){

            public MessageQueue select(List<MessageQueue> list, Message message, Object o) {
                for (MessageQueue mq : list) {
                    if (mq.getQueueId() != 0 || !mq.getBrokerName().equals(BROKER2_NAME)) continue;
                    return mq;
                }
                return list.get(8);
            }
        });
        this.producer.waitForResponse(5000);
        Truth.assertThat((Integer)this.producer.getSuccessMsgCount()).isEqualTo((Object)msgSize);
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        VerifyUtils.verifyMessageQueueId((int)0, (Collection)consumer.getListener().getAllOriginMsg());
    }
}

