/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.producer.async;

import com.google.common.truth.Truth;
import java.util.List;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.factory.ProducerFactory;
import org.apache.rocketmq.test.factory.SendCallBackFactory;
import org.apache.rocketmq.test.util.RandomUtils;
import org.apache.rocketmq.test.util.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AsyncSendExceptionIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TagMessageWith1ConsumerIT.class);
    private static boolean sendFail = false;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = AsyncSendExceptionIT.initTopic();
        logger.info(String.format("user topic[%s]!", this.topic));
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSendCallBackNull() throws Exception {
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        SendCallback sendCallback = null;
        producer.send(msg, sendCallback);
    }

    @Test
    public void testSendMQNull() throws Exception {
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        MessageQueue messageQueue = null;
        producer.send(msg, messageQueue, SendCallBackFactory.getSendCallBack());
    }

    @Test
    public void testSendSelectorNull() throws Exception {
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        MessageQueueSelector selector = null;
        producer.send(msg, selector, (Object)100, SendCallBackFactory.getSendCallBack());
    }

    @Test
    public void testSelectorThrowsException() throws Exception {
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        producer.send(msg, new MessageQueueSelector(){

            public MessageQueue select(List<MessageQueue> list, Message message, Object o) {
                String str = null;
                return list.get(str.length());
            }
        }, null, SendCallBackFactory.getSendCallBack());
    }

    @Test
    public void testQueueIdBigThanQueueNum() throws Exception {
        int queueId = 100;
        sendFail = false;
        MessageQueue mq = new MessageQueue(this.topic, BROKER1_NAME, queueId);
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        producer.send(msg, mq, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(Throwable throwable) {
                sendFail = true;
            }
        });
        for (int checkNum = 50; !sendFail && checkNum > 0; --checkNum) {
            TestUtils.waitForMoment((long)100L);
        }
        producer.shutdown();
        Truth.assertThat((Boolean)sendFail).isEqualTo((Object)true);
    }

    @Test
    public void testQueueIdSmallZero() throws Exception {
        int queueId = -100;
        sendFail = true;
        MessageQueue mq = new MessageQueue(this.topic, BROKER1_NAME, queueId);
        Message msg = new Message(this.topic, RandomUtils.getStringByUUID().getBytes());
        DefaultMQProducer producer = ProducerFactory.getRMQProducer((String)NAMESRV_ADDR);
        producer.send(msg, mq, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                sendFail = false;
            }

            public void onException(Throwable throwable) {
                sendFail = true;
            }
        });
        for (int checkNum = 50; sendFail && checkNum > 0; --checkNum) {
            TestUtils.waitForMoment((long)100L);
        }
        producer.shutdown();
        Truth.assertThat((Boolean)sendFail).isEqualTo((Object)false);
    }
}

