/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.tag;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.RandomUtils;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TagMessageWithSameGroupConsumerIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;
    private String tag = "tag";

    @Before
    public void setUp() {
        this.topic = TagMessageWithSameGroupConsumerIT.initTopic();
        logger.info(String.format("use topic: %s !", this.topic));
        this.producer = TagMessageWithSameGroupConsumerIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testTwoConsumerWithSameGroup() {
        int msgSize = 20;
        String originMsgDCName = RandomUtils.getStringByUUID();
        String msgBodyDCName = RandomUtils.getStringByUUID();
        RMQNormalConsumer consumer1 = TagMessageWithSameGroupConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, this.tag, (AbstractListener)new RMQNormalListener(originMsgDCName, msgBodyDCName));
        TagMessageWithSameGroupConsumerIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.tag, (AbstractListener)new RMQNormalListener(originMsgDCName, msgBodyDCName));
        this.producer.send(this.tag, msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testConsumerStartWithInterval() {
        int msgSize = 100;
        String originMsgDCName = RandomUtils.getStringByUUID();
        String msgBodyDCName = RandomUtils.getStringByUUID();
        RMQNormalConsumer consumer1 = TagMessageWithSameGroupConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, this.tag, (AbstractListener)new RMQNormalListener(originMsgDCName, msgBodyDCName));
        this.producer.send(this.tag, msgSize, 100);
        TestUtils.waitForMoment((long)5L);
        TagMessageWithSameGroupConsumerIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.tag, (AbstractListener)new RMQNormalListener(originMsgDCName, msgBodyDCName));
        TestUtils.waitForMoment((long)5L);
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testConsumerStartTwoAndCrashOneAfterWhile() {
        int msgSize = 100;
        String originMsgDCName = RandomUtils.getStringByUUID();
        String msgBodyDCName = RandomUtils.getStringByUUID();
        RMQNormalConsumer consumer1 = TagMessageWithSameGroupConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, this.tag, (AbstractListener)new RMQNormalListener(originMsgDCName, msgBodyDCName));
        RMQNormalConsumer consumer2 = TagMessageWithSameGroupConsumerIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.tag, (AbstractListener)new RMQNormalListener(originMsgDCName, msgBodyDCName));
        this.producer.send(this.tag, msgSize, 100);
        TestUtils.waitForMoment((long)5L);
        consumer2.shutdown();
        mqClients.remove(1);
        TestUtils.waitForMoment((long)5L);
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

