/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.tag;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TagMessageWith1ConsumerIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = TagMessageWith1ConsumerIT.initTopic();
        String consumerId = TagMessageWith1ConsumerIT.initConsumerGroup();
        logger.info(String.format("use topic: %s; consumerId: %s !", this.topic, consumerId));
        this.producer = TagMessageWith1ConsumerIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testTagSmoke() {
        String tag = "jueyin";
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, tag, (AbstractListener)new RMQNormalListener());
        this.producer.send(tag, msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubAllMessageNoTag() {
        String subExprress = "*";
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, subExprress, (AbstractListener)new RMQNormalListener());
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubAllMessageWithTag() {
        String tag = "jueyin";
        String subExpress = "*";
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tag, msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubAllMessageWithNullTag() {
        String tag = null;
        String subExpress = "*";
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tag, msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubNullWithTagNull() {
        String tag = null;
        String subExpress = null;
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tag, msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubAllWithKindsOfMessage() {
        String tag1 = null;
        String tag2 = "jueyin";
        String subExpress = "*";
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        List tag1Msgs = MQMessageFactory.getRMQMessage(tag1, (String)this.topic, (int)msgSize);
        List tag2Msgs = MQMessageFactory.getRMQMessage((String)tag2, (String)this.topic, (int)msgSize);
        this.producer.send(tag1Msgs);
        this.producer.send(tag2Msgs);
        this.producer.send(10L);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 3), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubNullWithKindsOfMessage() {
        String tag1 = null;
        String tag2 = "jueyin";
        String subExpress = null;
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        List tag1Msgs = MQMessageFactory.getRMQMessage(tag1, (String)this.topic, (int)msgSize);
        List tag2Msgs = MQMessageFactory.getRMQMessage((String)tag2, (String)this.topic, (int)msgSize);
        this.producer.send(tag1Msgs);
        this.producer.send(tag2Msgs);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubTagWithKindsOfMessage() {
        String tag2;
        String tag1 = null;
        String subExpress = tag2 = "jueyin";
        int msgSize = 10;
        RMQNormalConsumer consumer = TagMessageWith1ConsumerIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        List tag1Msgs = MQMessageFactory.getRMQMessage(tag1, (String)this.topic, (int)msgSize);
        List tag2Msgs = MQMessageFactory.getRMQMessage((String)tag2, (String)this.topic, (int)msgSize);
        this.producer.send(tag1Msgs);
        this.producer.send(tag2Msgs);
        this.producer.send(10L);
        Assert.assertEquals((String)"Not all are sent", (long)(msgSize * 3), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume((Collection)MQMessageFactory.getMessageBody((List)tag2Msgs), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)MQMessageFactory.getMessageBody((List)tag2Msgs));
    }
}

