/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.tag;

import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.tag.TagMessageWith1ConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.factory.MQMessageFactory;
import org.apache.rocketmq.test.factory.TagMessage;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MulTagSubIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(TagMessageWith1ConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = MulTagSubIT.initTopic();
        String consumerId = MulTagSubIT.initConsumerGroup();
        logger.info(String.format("use topic: %s; consumerId: %s !", this.topic, consumerId));
        this.producer = MulTagSubIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testSubTwoTabMessageOnsTag() {
        String tag = "jueyin1";
        String subExpress = String.format("%s||jueyin2", tag);
        int msgSize = 10;
        RMQNormalConsumer consumer = MulTagSubIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tag, msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }

    @Test
    public void testSubTwoTabAndMatchOne() {
        String tag1 = "jueyin1";
        String tag2 = "jueyin2";
        String subExpress = String.format("%s||noExistTag", tag2);
        int msgSize = 10;
        RMQNormalConsumer consumer = MulTagSubIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tag1, msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        List tag2Msgs = MQMessageFactory.getRMQMessage((String)tag2, (String)this.topic, (int)msgSize);
        this.producer.send(tag2Msgs);
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * 2), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume((Collection)MQMessageFactory.getMessageBody((List)tag2Msgs), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)MQMessageFactory.getMessageBody((List)tag2Msgs));
    }

    @Test
    public void testSubTwoTabAndMatchTwo() {
        String[] tags = new String[]{"jueyin1", "jueyin2"};
        String subExpress = String.format("%s||%s", tags[0], tags[1]);
        int msgSize = 10;
        TagMessage tagMessage = new TagMessage(tags, this.topic, msgSize);
        RMQNormalConsumer consumer = MulTagSubIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tagMessage.getMixedTagMessages());
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * tags.length), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getAllTagMessageBody());
    }

    @Test
    public void testSubThreeTabAndMatchTwo() {
        String[] tags = new String[]{"jueyin1", "jueyin2", "jueyin3"};
        String subExpress = String.format("%s||%s", tags[0], tags[1]);
        int msgSize = 10;
        TagMessage tagMessage = new TagMessage(tags, this.topic, msgSize);
        RMQNormalConsumer consumer = MulTagSubIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tagMessage.getMixedTagMessages());
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * tags.length), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume((Collection)tagMessage.getMessageBodyByTag(new String[]{tags[0], tags[1]}), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)tagMessage.getMessageBodyByTag(new String[]{tags[0], tags[1]}));
    }

    @Test
    public void testNoMatch() {
        String[] tags = new String[]{"jueyin1", "jueyin2", "jueyin3"};
        String subExpress = "no_match";
        int msgSize = 10;
        TagMessage tagMessage = new TagMessage(tags, this.topic, msgSize);
        RMQNormalConsumer consumer = MulTagSubIT.getConsumer(NAMESRV_ADDR, this.topic, subExpress, (AbstractListener)new RMQNormalListener());
        this.producer.send(tagMessage.getMixedTagMessages());
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * tags.length), (long)this.producer.getAllUndupMsgBody().size());
        TestUtils.waitForSeconds((long)5L);
        Truth.assertThat((Integer)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody()).size()).isEqualTo((Object)0);
    }
}

