/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.pop;

import com.google.common.truth.StringSubject;
import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.common.message.MessageClientExt;
import org.apache.rocketmq.common.message.MessageRequestMode;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.client.rmq.RMQPopConsumer;
import org.apache.rocketmq.test.factory.ConsumerFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.RandomUtil;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class PopSubCheckIT
extends BaseConf {
    private static final Logger log = LoggerFactory.getLogger(PopSubCheckIT.class);
    private String group;
    private DefaultMQAdminExt defaultMQAdminExt;

    @Before
    public void setUp() throws Exception {
        this.group = PopSubCheckIT.initConsumerGroup();
        this.defaultMQAdminExt = new DefaultMQAdminExt();
        this.defaultMQAdminExt.setInstanceName(RandomUtil.getStringByUUID());
        this.defaultMQAdminExt.start();
    }

    @After
    public void tearDown() {
        this.defaultMQAdminExt.shutdown();
        BaseConf.shutdown();
    }

    @Ignore
    @Test
    public void testNormalPopAck() throws Exception {
        String topic = PopSubCheckIT.initTopic();
        log.info(String.format("use topic: %s; group: %s !", topic, this.group));
        RMQNormalProducer producer = PopSubCheckIT.getProducer(NAMESRV_ADDR, topic);
        producer.getProducer().setCompressMsgBodyOverHowmuch(Integer.MAX_VALUE);
        for (String brokerAddr : new String[]{brokerController1.getBrokerAddr(), brokerController2.getBrokerAddr()}) {
            this.defaultMQAdminExt.setMessageRequestMode(brokerAddr, topic, this.group, MessageRequestMode.POP, 8, 60000L);
        }
        RMQPopConsumer consumer = ConsumerFactory.getRMQPopConsumer((String)NAMESRV_ADDR, (String)this.group, (String)topic, (String)"*", (AbstractListener)new RMQNormalListener());
        mqClients.add(consumer);
        int msgNum = 1;
        producer.send((long)msgNum);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgNum, (long)producer.getAllUndupMsgBody().size());
        log.info(producer.getFirstMsg().toString());
        TestUtils.waitForSeconds((long)10L);
        consumer.getListener().waitForMessageConsume(msgNum, 30000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)producer.getAllMsgBody());
        for (Object o : consumer.getListener().getAllOriginMsg()) {
            MessageClientExt msg = (MessageClientExt)o;
            ((StringSubject)Truth.assertThat((String)msg.getProperty("POP_CK")).named("check pop meta", new Object[0])).isNotEmpty();
        }
        consumer.getListener().waitForMessageConsume(msgNum, 27000);
        Truth.assertThat((Integer)consumer.getListener().getAllOriginMsg().size()).isEqualTo((Object)msgNum);
    }
}

