/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.pop;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.test.client.consumer.pop.BasePop;
import org.apache.rocketmq.test.client.consumer.pop.BasePopOrderly;
import org.assertj.core.util.Lists;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Test;

public class PopOrderlyIT
extends BasePopOrderly {
    @Test
    public void testPopOrderly() {
        this.sendMessage(10);
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> {
            this.popMessageOrderly().get();
            return this.msgRecv.size() == 10;
        });
        this.assertMessageRecvOrder();
    }

    private CompletableFuture<Void> popMessageOrderly() {
        CompletableFuture<PopResult> future = this.popMessageOrderlyAsync(TimeUnit.SECONDS.toMillis(3L), 1, TimeUnit.SECONDS.toMillis(30L));
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        future.whenComplete((popResult, throwable) -> {
            if (throwable != null) {
                resultFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            if (popResult.getMsgFoundList() == null || popResult.getMsgFoundList().isEmpty()) {
                resultFuture.complete(null);
                return;
            }
            try {
                for (MessageExt messageExt : popResult.getMsgFoundList()) {
                    this.onRecvNewMessage(messageExt);
                    new Thread(() -> {
                        try {
                            TimeUnit.MILLISECONDS.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.ackMessageAsync(messageExt);
                    }).start();
                }
                resultFuture.complete(null);
            }
            catch (Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        });
        return resultFuture;
    }

    @Test
    public void testPopOrderlyThenNoAck() {
        this.sendMessage(10);
        Awaitility.await().atMost(Duration.ofSeconds(5L)).until(() -> {
            this.popOrderlyThenNoAck().get();
            return this.msgRecvSequence.size() == 10;
        });
        Assert.assertEquals((long)5L, (long)this.msgRecv.size());
        for (Map.Entry entry : this.msgRecv.entrySet()) {
            Assert.assertEquals((long)2L, (long)((List)entry.getValue()).size());
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                Assert.assertEquals((long)i, (long)((BasePop.MsgRcv)((List)entry.getValue()).get((int)i)).messageExt.getReconsumeTimes());
            }
        }
        this.assertMessageRecvOrder();
    }

    private CompletableFuture<Void> popOrderlyThenNoAck() {
        CompletableFuture<PopResult> future = this.popMessageOrderlyAsync(TimeUnit.SECONDS.toMillis(3L), 5, TimeUnit.SECONDS.toMillis(30L));
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        future.whenComplete((popResult, throwable) -> {
            if (throwable != null) {
                resultFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            if (popResult.getMsgFoundList() == null || popResult.getMsgFoundList().isEmpty()) {
                resultFuture.complete(null);
                return;
            }
            try {
                for (MessageExt messageExt : popResult.getMsgFoundList()) {
                    this.onRecvNewMessage(messageExt);
                }
                resultFuture.complete(null);
            }
            catch (Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        });
        return resultFuture;
    }

    @Test
    public void testPopMessageOrderlyThenChangeInvisibleTime() {
        this.sendMessage(1);
        Awaitility.await().atMost(Duration.ofSeconds(15L)).until(() -> {
            this.popMessageOrderlyThenChangeInvisibleTime().get();
            return this.msgRecvSequence.size() == 2;
        });
        this.assertMsgRecv(1, 2);
        this.assertMessageRecvOrder();
    }

    private CompletableFuture<Void> popMessageOrderlyThenChangeInvisibleTime() {
        CompletableFuture<PopResult> future = this.popMessageOrderlyAsync(TimeUnit.SECONDS.toMillis(3L), 1, TimeUnit.SECONDS.toMillis(30L));
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        future.whenComplete((popResult, throwable) -> {
            if (throwable != null) {
                resultFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            if (popResult.getMsgFoundList() == null || popResult.getMsgFoundList().isEmpty()) {
                resultFuture.complete(null);
                return;
            }
            try {
                for (MessageExt messageExt : popResult.getMsgFoundList()) {
                    this.onRecvNewMessage(messageExt);
                    if (this.msgRecvSequence.size() == 1) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(1L);
                            this.changeInvisibleTimeAsync(messageExt, 5000L).get();
                            continue;
                        }
                        catch (Exception e) {
                            resultFuture.completeExceptionally(e);
                            return;
                        }
                    }
                    try {
                        this.ackMessageAsync(messageExt).get();
                    }
                    catch (Exception e) {
                        resultFuture.completeExceptionally(e);
                        return;
                    }
                }
                resultFuture.complete(null);
            }
            catch (Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        });
        return resultFuture;
    }

    @Test
    public void testPopMessageOrderlyThenChangeInvisibleTimeMidMessage() {
        this.producer.send(4L);
        Awaitility.await().atMost(Duration.ofSeconds(5L)).until(() -> {
            this.popMessageOrderlyThenChangeInvisibleTimeMidMessage().get();
            return this.msgRecvSequence.size() == 6;
        });
        this.assertMsgRecv(0, 1);
        this.assertMsgRecv(1, 2);
        this.assertMsgRecv(2, 2);
        this.assertMsgRecv(5, 1);
        Assert.assertEquals(this.msgRecvSequence.get(1), this.msgRecvSequence.get(3));
        Assert.assertEquals(this.msgRecvSequence.get(2), this.msgRecvSequence.get(4));
    }

    private CompletableFuture<Void> popMessageOrderlyThenChangeInvisibleTimeMidMessage() {
        CompletableFuture<PopResult> future = this.popMessageOrderlyAsync(5000L, 3, TimeUnit.SECONDS.toMillis(30L));
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        future.whenComplete((popResult, throwable) -> {
            if (throwable != null) {
                resultFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            if (popResult.getMsgFoundList() == null || popResult.getMsgFoundList().isEmpty()) {
                resultFuture.complete(null);
                return;
            }
            try {
                for (MessageExt messageExt : popResult.getMsgFoundList()) {
                    this.onRecvNewMessage(messageExt);
                    if (this.msgRecv.size() != 2) {
                        try {
                            this.ackMessageAsync(messageExt).get();
                            continue;
                        }
                        catch (Exception e) {
                            resultFuture.completeExceptionally(e);
                            return;
                        }
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(1L);
                        this.changeInvisibleTimeAsync(messageExt, 3000L).get();
                    }
                    catch (Exception e) {
                        resultFuture.completeExceptionally(e);
                        return;
                    }
                }
                resultFuture.complete(null);
            }
            catch (Throwable t) {
                resultFuture.completeExceptionally(t);
            }
        });
        return resultFuture;
    }

    @Test
    public void testReentrant() {
        this.producer.send(1L);
        this.popMessageForReentrant(null).join();
        this.assertMsgRecv(0, 1, Lists.newArrayList((Object[])new Integer[]{0}));
        String attemptId01 = "attemptId-01";
        this.popMessageForReentrant(attemptId01).join();
        this.assertMsgRecv(0, 2, Lists.newArrayList((Object[])new Integer[]{0, 1}));
        this.popMessageForReentrant(attemptId01).join();
        this.assertMsgRecv(0, 3, Lists.newArrayList((Object[])new Integer[]{0, 1, 1}));
        String attemptId02 = "attemptId-02";
        Awaitility.await().atLeast(Duration.ofSeconds(5L)).atMost(Duration.ofSeconds(15L)).until(() -> {
            this.popMessageForReentrant(attemptId02).join();
            return this.msgRecvSequence.size() == 4;
        });
        this.popMessageForReentrant(attemptId02).join();
        this.assertMsgRecv(0, 5, Lists.newArrayList((Object[])new Integer[]{0, 1, 1, 2, 2}));
        Awaitility.await().atLeast(Duration.ofSeconds(5L)).atMost(Duration.ofSeconds(15L)).until(() -> {
            this.popMessageForReentrant(null).join();
            return this.msgRecvSequence.size() == 6;
        });
        this.assertMsgRecv(0, 6, Lists.newArrayList((Object[])new Integer[]{0, 1, 1, 2, 2, 3}));
    }

    private CompletableFuture<Void> popMessageForReentrant(String attemptId) {
        return this.popMessageOrderlyAsync(TimeUnit.SECONDS.toMillis(10L), 3, TimeUnit.SECONDS.toMillis(30L), attemptId).thenAccept(popResult -> {
            for (MessageExt messageExt : popResult.getMsgFoundList()) {
                this.onRecvNewMessage(messageExt);
            }
        });
    }
}

