/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.pop;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PopStatus;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.test.base.IntegrationTestBase;
import org.apache.rocketmq.test.client.consumer.pop.BasePop;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.client.rmq.RMQPopClient;
import org.apache.rocketmq.test.util.MQRandomUtils;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PopMessageAndForwardingIT
extends BasePop {
    protected String topic;
    protected String group;
    protected RMQNormalProducer producer = null;
    protected RMQPopClient client = null;
    protected String broker1Addr;
    protected MessageQueue broker1MessageQueue;
    protected String broker2Addr;
    protected MessageQueue broker2MessageQueue;

    @Before
    public void setUp() {
        this.broker1Addr = brokerController1.getBrokerAddr();
        this.broker2Addr = brokerController2.getBrokerAddr();
        this.topic = MQRandomUtils.getRandomTopic();
        this.group = PopMessageAndForwardingIT.initConsumerGroup();
        IntegrationTestBase.initTopic(this.topic, NAMESRV_ADDR, BROKER1_NAME, 8, CQType.SimpleCQ, TopicMessageType.NORMAL);
        IntegrationTestBase.initTopic(this.topic, NAMESRV_ADDR, BROKER2_NAME, 8, CQType.SimpleCQ, TopicMessageType.NORMAL);
        this.producer = PopMessageAndForwardingIT.getProducer(NAMESRV_ADDR, this.topic);
        this.client = this.getRMQPopClient();
        this.broker1MessageQueue = new MessageQueue(this.topic, BROKER1_NAME, -1);
        this.broker2MessageQueue = new MessageQueue(this.topic, BROKER2_NAME, -1);
    }

    @Test
    public void test() {
        this.producer.send(1, this.broker1MessageQueue);
        AtomicReference firstMessageExtRef = new AtomicReference();
        Awaitility.await().atMost(Duration.ofSeconds(3L)).until(() -> {
            PopResult popResult = (PopResult)this.client.popMessageAsync(this.broker1Addr, this.broker1MessageQueue, 3000L, 32, this.group, 1000L, true, 0, false, "TAG", "*").get();
            if (!popResult.getPopStatus().equals((Object)PopStatus.FOUND)) {
                return false;
            }
            firstMessageExtRef.set(popResult.getMsgFoundList().get(0));
            return true;
        });
        this.producer.sendMQ((Message)firstMessageExtRef.get(), this.broker2MessageQueue);
        AtomicReference secondMessageExtRef = new AtomicReference();
        Awaitility.await().atMost(Duration.ofSeconds(3L)).until(() -> {
            PopResult popResult = (PopResult)this.client.popMessageAsync(this.broker2Addr, this.broker2MessageQueue, 3000L, 32, this.group, 1000L, true, 0, false, "TAG", "*").get();
            if (!popResult.getPopStatus().equals((Object)PopStatus.FOUND)) {
                return false;
            }
            secondMessageExtRef.set(popResult.getMsgFoundList().get(0));
            return true;
        });
        Assert.assertEquals((Object)((MessageExt)firstMessageExtRef.get()).getMsgId(), (Object)((MessageExt)secondMessageExtRef.get()).getMsgId());
        String firstPopCk = ((MessageExt)firstMessageExtRef.get()).getProperty("POP_CK");
        String secondPopCk = ((MessageExt)secondMessageExtRef.get()).getProperty("POP_CK");
        Assert.assertNotEquals((Object)firstPopCk, (Object)secondPopCk);
        Assert.assertEquals((Object)BROKER1_NAME, (Object)ExtraInfoUtil.getBrokerName((String[])ExtraInfoUtil.split((String)firstPopCk)));
        Assert.assertEquals((Object)BROKER2_NAME, (Object)ExtraInfoUtil.getBrokerName((String[])ExtraInfoUtil.split((String)secondPopCk)));
    }
}

