/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.pop;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.test.base.IntegrationTestBase;
import org.apache.rocketmq.test.client.consumer.pop.BasePop;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.client.rmq.RMQPopClient;
import org.apache.rocketmq.test.message.MessageQueueMsg;
import org.apache.rocketmq.test.util.MQRandomUtils;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.Test;

public class NotificationIT
extends BasePop {
    protected String topic;
    protected String group;
    protected RMQNormalProducer producer = null;
    protected RMQPopClient client = null;
    protected String brokerAddr;
    protected MessageQueue messageQueue;

    @Before
    public void setUp() {
        this.brokerAddr = brokerController1.getBrokerAddr();
        this.topic = MQRandomUtils.getRandomTopic();
        this.group = NotificationIT.initConsumerGroup();
        IntegrationTestBase.initTopic(this.topic, NAMESRV_ADDR, BROKER1_NAME, 8, CQType.SimpleCQ, TopicMessageType.NORMAL);
        this.producer = NotificationIT.getProducer(NAMESRV_ADDR, this.topic);
        this.client = this.getRMQPopClient();
        this.messageQueue = new MessageQueue(this.topic, BROKER1_NAME, -1);
    }

    @Test
    public void testNotification() throws Exception {
        long pollTime = 500L;
        CompletableFuture future1 = this.client.notification(this.brokerAddr, this.topic, this.group, this.messageQueue.getQueueId(), pollTime, System.currentTimeMillis(), 5000L);
        CompletableFuture future2 = this.client.notification(this.brokerAddr, this.topic, this.group, this.messageQueue.getQueueId(), pollTime, System.currentTimeMillis(), 5000L);
        this.sendMessage(1);
        Boolean result1 = (Boolean)future1.get();
        AssertionsForClassTypes.assertThat((Boolean)result1).isTrue();
        this.client.popMessageAsync(this.brokerAddr, this.messageQueue, 10000L, 1, this.group, 1000L, false, 0, false, null, null);
        Boolean result2 = (Boolean)future2.get();
        AssertionsForClassTypes.assertThat((Boolean)result2).isFalse();
    }

    @Test
    public void testNotificationOrderly() throws Exception {
        long pollTime = 500L;
        String attemptId = "attemptId";
        CompletableFuture future1 = this.client.notification(this.brokerAddr, this.topic, this.group, this.messageQueue.getQueueId(), Boolean.valueOf(true), attemptId, pollTime, System.currentTimeMillis(), 5000L);
        CompletableFuture future2 = this.client.notification(this.brokerAddr, this.topic, this.group, this.messageQueue.getQueueId(), Boolean.valueOf(true), attemptId, pollTime, System.currentTimeMillis(), 5000L);
        this.sendMessage(1);
        Boolean result1 = (Boolean)future1.get();
        AssertionsForClassTypes.assertThat((Boolean)result1).isTrue();
        this.client.popMessageAsync(this.brokerAddr, this.messageQueue, 10000L, 1, this.group, 1000L, false, 0, true, null, null, attemptId);
        Boolean result2 = (Boolean)future2.get();
        AssertionsForClassTypes.assertThat((Boolean)result2).isTrue();
        String attemptId2 = "attemptId2";
        CompletableFuture future3 = this.client.notification(this.brokerAddr, this.topic, this.group, this.messageQueue.getQueueId(), Boolean.valueOf(true), attemptId2, pollTime, System.currentTimeMillis(), 5000L);
        AssertionsForClassTypes.assertThat((Boolean)((Boolean)future3.get())).isFalse();
    }

    protected void sendMessage(int num) {
        MessageQueueMsg mqMsgs = new MessageQueueMsg((List)Lists.newArrayList((Object[])new MessageQueue[]{this.messageQueue}), num);
        this.producer.send(mqMsgs.getMsgsWithMQ());
    }
}

