/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.filter;

import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.client.rmq.RMQSqlConsumer;
import org.apache.rocketmq.test.factory.ConsumerFactory;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlFilterIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(SqlFilterIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;
    private static final Map<MessageQueue, Long> OFFSE_TABLE = new HashMap<MessageQueue, Long>();

    @Before
    public void setUp() {
        this.topic = SqlFilterIT.initTopic();
        logger.info(String.format("use topic: %s;", this.topic));
        this.producer = SqlFilterIT.getProducer(NAMESRV_ADDR, this.topic);
        OFFSE_TABLE.clear();
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testFilterConsumer() throws Exception {
        int msgSize = 16;
        String group = SqlFilterIT.initConsumerGroup();
        MessageSelector selector = MessageSelector.bySql((String)"(TAGS is not null and TAGS in ('TagA', 'TagB'))");
        RMQSqlConsumer consumer = ConsumerFactory.getRMQSqlConsumer((String)NAMESRV_ADDR, (String)group, (String)this.topic, (MessageSelector)selector, (AbstractListener)new RMQNormalListener(group + "_1"));
        Thread.sleep(3000L);
        this.producer.send("TagA", msgSize);
        this.producer.send("TagB", msgSize);
        this.producer.send("TagC", msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * 3), (long)this.producer.getAllUndupMsgBody().size());
        consumer.getListener().waitForMessageConsume(msgSize * 2, 120000);
        Truth.assertThat((Iterable)this.producer.getAllMsgBody()).containsAllIn((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer.getListener().getAllMsgBody()));
        Truth.assertThat((Integer)consumer.getListener().getAllMsgBody().size()).isEqualTo((Object)(msgSize * 2));
    }

    @Test
    public void testFilterPullConsumer() throws Exception {
        int msgSize = 16;
        String group = SqlFilterIT.initConsumerGroup();
        MessageSelector selector = MessageSelector.bySql((String)"(TAGS is not null and TAGS in ('TagA', 'TagB'))");
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer(group);
        consumer.setNamesrvAddr(NAMESRV_ADDR);
        consumer.start();
        Thread.sleep(3000L);
        this.producer.send("TagA", msgSize);
        this.producer.send("TagB", msgSize);
        this.producer.send("TagC", msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)(msgSize * 3), (long)this.producer.getAllUndupMsgBody().size());
        ArrayList<String> receivedMessage = new ArrayList<String>(2);
        Set mqs = consumer.fetchSubscribeMessageQueues(this.topic);
        block8: for (MessageQueue mq : mqs) {
            block9: while (true) {
                try {
                    while (true) {
                        PullResult pullResult = consumer.pull(mq, selector, SqlFilterIT.getMessageQueueOffset(mq), 32);
                        SqlFilterIT.putMessageQueueOffset(mq, pullResult.getNextBeginOffset());
                        switch (pullResult.getPullStatus()) {
                            case FOUND: {
                                List msgs = pullResult.getMsgFoundList();
                                Iterator iterator = msgs.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block9;
                                    MessageExt msg = (MessageExt)iterator.next();
                                    receivedMessage.add(new String(msg.getBody()));
                                }
                            }
                            case NO_MATCHED_MSG: {
                                break;
                            }
                            case NO_NEW_MSG: {
                                continue block8;
                            }
                            case OFFSET_ILLEGAL: {
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)receivedMessage.size()).isEqualTo((Object)(msgSize * 2));
    }

    private static long getMessageQueueOffset(MessageQueue mq) {
        Long offset = OFFSE_TABLE.get(mq);
        if (offset != null) {
            return offset;
        }
        return 0L;
    }

    private static void putMessageQueueOffset(MessageQueue mq, long offset) {
        OFFSE_TABLE.put(mq, offset);
    }
}

