/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.cluster;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.consumer.balance.NormalMsgStaticBalanceIT;
import org.apache.rocketmq.test.client.mq.MQAsyncProducer;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.clientinterface.AbstractMQProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQWait;
import org.apache.rocketmq.test.util.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DynamicAddAndCrashIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(NormalMsgStaticBalanceIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = DynamicAddAndCrashIT.initTopic();
        logger.info(String.format("use topic: %s !", this.topic));
        this.producer = DynamicAddAndCrashIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testAddOneConsumerAndCrashAfterWhile() {
        int msgSize = 150;
        RMQNormalConsumer consumer1 = DynamicAddAndCrashIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
        MQAsyncProducer asyncDefaultMQProducer = new MQAsyncProducer((AbstractMQProducer)this.producer, (long)msgSize, 100);
        asyncDefaultMQProducer.start();
        TestUtils.waitForSeconds((long)5L);
        RMQNormalConsumer consumer2 = DynamicAddAndCrashIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)5L);
        consumer2.shutdown();
        asyncDefaultMQProducer.waitSendAll(30);
        MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }

    @Test
    public void testAddTwoConsumerAndCrashAfterWhile() {
        int msgSize = 150;
        RMQNormalConsumer consumer1 = DynamicAddAndCrashIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
        MQAsyncProducer asyncDefaultMQProducer = new MQAsyncProducer((AbstractMQProducer)this.producer, (long)msgSize, 100);
        asyncDefaultMQProducer.start();
        TestUtils.waitForSeconds((long)5L);
        RMQNormalConsumer consumer2 = DynamicAddAndCrashIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer3 = DynamicAddAndCrashIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)5L);
        consumer2.shutdown();
        consumer3.shutdown();
        asyncDefaultMQProducer.waitSendAll(30);
        MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener()});
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
    }
}

