/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.tag;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadcast;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadcastTwoConsumerSubTagIT
extends BaseBroadcast {
    private static Logger logger = LoggerFactory.getLogger(BroadcastTwoConsumerSubTagIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = BroadcastTwoConsumerSubTagIT.initTopic();
        logger.info(String.format("use topic: %s;", this.topic));
        this.producer = BroadcastTwoConsumerSubTagIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadcast.shutdown();
    }

    @Test
    public void testTwoConsumerSubTag() {
        int msgSize = 20;
        String tag = "jueyin_tag";
        RMQBroadCastConsumer consumer1 = BroadcastTwoConsumerSubTagIT.getBroadCastConsumer(NAMESRV_ADDR, this.topic, tag, (AbstractListener)new RMQNormalListener());
        RMQBroadCastConsumer consumer2 = BroadcastTwoConsumerSubTagIT.getBroadCastConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, tag, (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)5L);
        this.producer.send(tag, msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        consumer2.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

