/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.normal;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadcast;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NormalMsgTwoSameGroupConsumerIT
extends BaseBroadcast {
    private static Logger logger = LoggerFactory.getLogger(NormalMsgTwoSameGroupConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.printSeparator();
        this.topic = NormalMsgTwoSameGroupConsumerIT.initTopic();
        logger.info(String.format("use topic: %s;", this.topic));
        this.producer = NormalMsgTwoSameGroupConsumerIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadcast.shutdown();
    }

    @Test
    public void testStartTwoSameGroupConsumer() {
        int msgSize = 16;
        String group = NormalMsgTwoSameGroupConsumerIT.initConsumerGroup();
        RMQBroadCastConsumer consumer1 = NormalMsgTwoSameGroupConsumerIT.getBroadCastConsumer(NAMESRV_ADDR, group, this.topic, "*", (AbstractListener)new RMQNormalListener(group + "_1"));
        RMQBroadCastConsumer consumer2 = NormalMsgTwoSameGroupConsumerIT.getBroadCastConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener(group + "_2"));
        TestUtils.waitForSeconds((long)5L);
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        consumer2.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
    }
}

