/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.broadcast.normal;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.client.consumer.broadcast.BaseBroadcast;
import org.apache.rocketmq.test.client.consumer.broadcast.normal.NormalMsgTwoSameGroupConsumerIT;
import org.apache.rocketmq.test.client.rmq.RMQBroadCastConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadcastNormalMsgNotReceiveIT
extends BaseBroadcast {
    private static Logger logger = LoggerFactory.getLogger(NormalMsgTwoSameGroupConsumerIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.printSeparator();
        this.topic = BroadcastNormalMsgNotReceiveIT.initTopic();
        logger.info(String.format("use topic: %s;", this.topic));
        this.producer = BroadcastNormalMsgNotReceiveIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseBroadcast.shutdown();
    }

    @Test
    public void testNotConsumeAfterConsume() throws Exception {
        int msgSize = 16;
        String group = BroadcastNormalMsgNotReceiveIT.initConsumerGroup();
        RMQBroadCastConsumer consumer1 = BroadcastNormalMsgNotReceiveIT.getBroadCastConsumer(NAMESRV_ADDR, group, this.topic, "*", (AbstractListener)new RMQNormalListener(group + "_1"));
        Thread.sleep(3000L);
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all sent succeeded", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        consumer1.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 120000);
        Truth.assertThat((Iterable)VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllMsgBody())).containsExactlyElementsIn((Iterable)this.producer.getAllMsgBody());
        RMQBroadCastConsumer consumer2 = BroadcastNormalMsgNotReceiveIT.getBroadCastConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener(group + "_2"));
        consumer2.getListener().waitForMessageConsume(this.producer.getAllMsgBody(), 5);
        Truth.assertThat((Integer)consumer2.getListener().getAllMsgBody().size()).isEqualTo((Object)0);
    }
}

