/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.client.consumer.balance;

import com.google.common.truth.Truth;
import java.util.Collection;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.test.base.BaseConf;
import org.apache.rocketmq.test.client.rmq.RMQNormalConsumer;
import org.apache.rocketmq.test.client.rmq.RMQNormalProducer;
import org.apache.rocketmq.test.listener.AbstractListener;
import org.apache.rocketmq.test.listener.rmq.concurrent.RMQNormalListener;
import org.apache.rocketmq.test.util.MQWait;
import org.apache.rocketmq.test.util.TestUtils;
import org.apache.rocketmq.test.util.VerifyUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NormalMsgStaticBalanceIT
extends BaseConf {
    private static Logger logger = LoggerFactory.getLogger(NormalMsgStaticBalanceIT.class);
    private RMQNormalProducer producer = null;
    private String topic = null;

    @Before
    public void setUp() {
        this.topic = NormalMsgStaticBalanceIT.initTopic();
        logger.info(String.format("use topic: %s !", this.topic));
        this.producer = NormalMsgStaticBalanceIT.getProducer(NAMESRV_ADDR, this.topic);
    }

    @After
    public void tearDown() {
        BaseConf.shutdown();
    }

    @Test
    public void testTwoConsumersBalance() {
        int msgSize = 400;
        RMQNormalConsumer consumer1 = NormalMsgStaticBalanceIT.getConsumer(NAMESRV_ADDR, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer2 = NormalMsgStaticBalanceIT.getConsumer(NAMESRV_ADDR, consumer1.getConsumerGroup(), this.topic, "*", (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)5L);
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        boolean balance = VerifyUtils.verifyBalance((int)msgSize, (int[])new int[]{VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllUndupMsgBody()).size()});
        Truth.assertThat((Boolean)balance).isEqualTo((Object)true);
    }

    @Test
    public void testFourConsumersBalance() {
        int msgSize = 600;
        String consumerGroup = NormalMsgStaticBalanceIT.initConsumerGroup();
        logger.info("use group: {}", (Object)consumerGroup);
        RMQNormalConsumer consumer1 = NormalMsgStaticBalanceIT.getConsumer(NAMESRV_ADDR, consumerGroup, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer2 = NormalMsgStaticBalanceIT.getConsumer(NAMESRV_ADDR, consumerGroup, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer3 = NormalMsgStaticBalanceIT.getConsumer(NAMESRV_ADDR, consumerGroup, this.topic, "*", (AbstractListener)new RMQNormalListener());
        RMQNormalConsumer consumer4 = NormalMsgStaticBalanceIT.getConsumer(NAMESRV_ADDR, consumerGroup, this.topic, "*", (AbstractListener)new RMQNormalListener());
        TestUtils.waitForSeconds((long)5L);
        this.producer.send((long)msgSize);
        Assert.assertEquals((String)"Not all are sent", (long)msgSize, (long)this.producer.getAllUndupMsgBody().size());
        boolean recvAll = MQWait.waitConsumeAll((int)120000, (Collection)this.producer.getAllMsgBody(), (AbstractListener[])new AbstractListener[]{consumer1.getListener(), consumer2.getListener(), consumer3.getListener(), consumer4.getListener()});
        Truth.assertThat((Boolean)recvAll).isEqualTo((Object)true);
        boolean balance = VerifyUtils.verifyBalance((int)msgSize, (int[])new int[]{VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer1.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer2.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer3.getListener().getAllUndupMsgBody()).size(), VerifyUtils.getFilterdMessage((Collection)this.producer.getAllMsgBody(), (Collection)consumer4.getListener().getAllUndupMsgBody()).size()});
        Truth.assertThat((Boolean)balance).isEqualTo((Object)true);
    }
}

