/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.autoswitchrole;

import java.io.File;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.controller.ReplicasManager;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.controller.ControllerManager;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoResponseHeader;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.ha.HAClient;
import org.apache.rocketmq.store.ha.HAConnectionState;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.test.autoswitchrole.AutoSwitchRoleBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class AutoSwitchRoleIntegrationTest
extends AutoSwitchRoleBase {
    private static final int DEFAULT_FILE_SIZE = 0x100000;
    private static NamesrvController namesrvController;
    private static ControllerManager controllerManager;
    private static String nameserverAddress;
    private static String controllerAddress;
    private static ControllerConfig controllerConfig;
    private BrokerController brokerController1;
    private BrokerController brokerController2;
    private Random random = new Random();

    @BeforeClass
    public static void init() throws Exception {
        AutoSwitchRoleIntegrationTest.initialize();
        int controllerPort = AutoSwitchRoleIntegrationTest.nextPort();
        String peers = String.format("n0-localhost:%d", controllerPort);
        NettyServerConfig serverConfig = new NettyServerConfig();
        int namesrvPort = AutoSwitchRoleIntegrationTest.nextPort();
        serverConfig.setListenPort(namesrvPort);
        controllerConfig = AutoSwitchRoleIntegrationTest.buildControllerConfig("n0", peers);
        namesrvController = new NamesrvController(new NamesrvConfig(), serverConfig, new NettyClientConfig());
        Assert.assertTrue((boolean)namesrvController.initialize());
        namesrvController.start();
        AutoSwitchRoleIntegrationTest.initAndStartControllerManager();
        nameserverAddress = "127.0.0.1:" + namesrvPort + ";";
        controllerAddress = "127.0.0.1:" + controllerPort + ";";
    }

    private static void initAndStartControllerManager() {
        controllerManager = new ControllerManager(controllerConfig, new NettyServerConfig(), new NettyClientConfig());
        Assert.assertTrue((boolean)controllerManager.initialize());
        controllerManager.start();
    }

    public void initBroker(int mappedFileSize, String brokerName) throws Exception {
        this.brokerController1 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 1, AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), BrokerRole.SYNC_MASTER, mappedFileSize);
        this.brokerController2 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 2, AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), BrokerRole.SLAVE, mappedFileSize);
        Assert.assertTrue((boolean)this.waitSlaveReady(this.brokerController2.getMessageStore()));
        Thread.sleep(1000L);
    }

    public void mockData(String topic) throws Exception {
        MessageStore messageStore = this.brokerController1.getMessageStore();
        this.putMessage(messageStore, topic);
        this.checkMessage(this.brokerController2.getMessageStore(), topic, 10, 0);
    }

    public boolean waitSlaveReady(MessageStore messageStore) throws InterruptedException {
        for (int tryTimes = 0; tryTimes < 100; ++tryTimes) {
            HAClient haClient = messageStore.getHaService().getHAClient();
            if (haClient != null && haClient.getCurrentState().equals((Object)HAConnectionState.TRANSFER)) {
                return true;
            }
            Thread.sleep(2000L);
        }
        return false;
    }

    @Test
    public void testCheckSyncStateSet() throws Exception {
        String topic = "Topic-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        String brokerName = "Broker-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        this.initBroker(0x100000, brokerName);
        this.mockData(topic);
        ReplicasManager replicasManager = this.brokerController1.getReplicasManager();
        SyncStateSet syncStateSet = replicasManager.getSyncStateSet();
        Assert.assertEquals((long)2L, (long)syncStateSet.getSyncStateSet().size());
        ScheduledExecutorService singleThread = Executors.newSingleThreadScheduledExecutor();
        while (!singleThread.awaitTermination(6000L, TimeUnit.MILLISECONDS)) {
            this.brokerController2.shutdown();
            singleThread.shutdown();
        }
        syncStateSet = replicasManager.getSyncStateSet();
        this.shutdownAndClearBroker();
        Assert.assertEquals((long)1L, (long)syncStateSet.getSyncStateSet().size());
    }

    @Test
    public void testChangeMaster() throws Exception {
        String topic = "Topic-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        String brokerName = "Broker-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        this.initBroker(0x100000, brokerName);
        int listenPort = this.brokerController1.getBrokerConfig().getListenPort();
        int nettyPort = this.brokerController1.getNettyServerConfig().getListenPort();
        this.mockData(topic);
        this.brokerController1.shutdown();
        brokerList.remove(this.brokerController1);
        Thread.sleep(6000L);
        Assert.assertTrue((boolean)this.brokerController2.getReplicasManager().isMasterState());
        Assert.assertEquals((long)this.brokerController2.getReplicasManager().getMasterEpoch(), (long)2L);
        this.brokerController1 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 1, AutoSwitchRoleIntegrationTest.nextPort(), listenPort, nettyPort, BrokerRole.SLAVE, 0x100000);
        this.waitSlaveReady(this.brokerController1.getMessageStore());
        Assert.assertFalse((boolean)this.brokerController1.getReplicasManager().isMasterState());
        Assert.assertEquals((Object)this.brokerController1.getReplicasManager().getMasterAddress(), (Object)this.brokerController2.getReplicasManager().getBrokerAddress());
        MessageStore messageStore = this.brokerController2.getMessageStore();
        this.putMessage(messageStore, topic);
        this.checkMessage(this.brokerController1.getMessageStore(), topic, 20, 0);
        this.shutdownAndClearBroker();
    }

    @Test
    public void testRestartWithChangedAddress() throws Exception {
        String topic = "Topic-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        String brokerName = "Broker-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        int oldPort = AutoSwitchRoleIntegrationTest.nextPort();
        this.brokerController1 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 1, AutoSwitchRoleIntegrationTest.nextPort(), oldPort, oldPort, BrokerRole.SYNC_MASTER, 0x100000);
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.brokerController1.getReplicasManager().isMasterState());
        Assert.assertEquals((long)this.brokerController1.getReplicasManager().getMasterEpoch(), (long)1L);
        this.brokerController1.shutdown();
        brokerList.remove(this.brokerController1);
        Thread.sleep(6000L);
        int newPort = AutoSwitchRoleIntegrationTest.nextPort();
        this.brokerController1 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 1, AutoSwitchRoleIntegrationTest.nextPort(), newPort, newPort, BrokerRole.SYNC_MASTER, 0x100000);
        Thread.sleep(1000L);
        Assert.assertEquals((long)1L, (long)this.brokerController1.getReplicasManager().getBrokerControllerId());
        Assert.assertTrue((boolean)this.brokerController1.getReplicasManager().isMasterState());
        RemotingCommand remotingCommand = (RemotingCommand)controllerManager.getController().getReplicaInfo(new GetReplicaInfoRequestHeader(brokerName)).get(500L, TimeUnit.MILLISECONDS);
        GetReplicaInfoResponseHeader resp = (GetReplicaInfoResponseHeader)remotingCommand.readCustomHeader();
        Assert.assertEquals((long)1L, (long)resp.getMasterBrokerId());
        Assert.assertTrue((boolean)resp.getMasterAddress().contains(String.valueOf(newPort)));
        this.shutdownAndClearBroker();
    }

    @Test
    public void testBasicWorkWhenControllerShutdown() throws Exception {
        String topic = "Foobar";
        String brokerName = "Broker-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt();
        this.initBroker(0x100000, brokerName);
        this.putMessage(this.brokerController1.getMessageStore(), topic);
        this.checkMessage(this.brokerController2.getMessageStore(), topic, 10, 0);
        controllerManager.shutdown();
        this.putMessage(this.brokerController1.getMessageStore(), topic);
        this.checkMessage(this.brokerController2.getMessageStore(), topic, 20, 0);
        AutoSwitchRoleIntegrationTest.initAndStartControllerManager();
    }

    @Test
    public void testAddBroker() throws Exception {
        String topic = "Topic-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        String brokerName = "Broker-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        this.initBroker(0x100000, brokerName);
        this.mockData(topic);
        BrokerController broker3 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 3, AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), BrokerRole.SLAVE, 0x100000);
        this.waitSlaveReady(broker3.getMessageStore());
        this.checkMessage(broker3.getMessageStore(), topic, 10, 0);
        this.putMessage(this.brokerController1.getMessageStore(), topic);
        this.checkMessage(broker3.getMessageStore(), topic, 20, 0);
        this.shutdownAndClearBroker();
    }

    @Test
    public void testTruncateEpochLogAndChangeMaster() throws Exception {
        this.shutdownAndClearBroker();
        String topic = "FooBar";
        String brokerName = "Broker-" + AutoSwitchRoleIntegrationTest.class.getSimpleName() + this.random.nextInt(65535);
        this.initBroker(1700, brokerName);
        this.putMessage(this.brokerController1.getMessageStore(), topic);
        this.checkMessage(this.brokerController2.getMessageStore(), topic, 10, 0);
        this.brokerController1.shutdown();
        brokerList.remove(this.brokerController1);
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)this.brokerController2.getReplicasManager().isMasterState());
        Assert.assertEquals((long)this.brokerController2.getReplicasManager().getMasterEpoch(), (long)2L);
        BrokerController broker3 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 3, AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), BrokerRole.SLAVE, 1700);
        this.waitSlaveReady(broker3.getMessageStore());
        this.checkMessage(broker3.getMessageStore(), topic, 10, 0);
        this.putMessage(this.brokerController2.getMessageStore(), topic);
        this.checkMessage(broker3.getMessageStore(), topic, 20, 0);
        MessageStore broker2MessageStore = this.brokerController2.getMessageStore();
        MappedFileQueue fileQueue = broker2MessageStore.getCommitLog().getMappedFileQueue();
        Assert.assertEquals((long)2L, (long)(fileQueue.getTotalFileSize() / 1700L));
        MappedFile firstFile = broker2MessageStore.getCommitLog().getMappedFileQueue().getFirstMappedFile();
        firstFile.shutdown(1000L);
        fileQueue.retryDeleteFirstFile(1000L);
        Assert.assertEquals((long)broker2MessageStore.getCommitLog().getMinOffset(), (long)1700L);
        AutoSwitchHAService haService = (AutoSwitchHAService)this.brokerController2.getMessageStore().getHaService();
        haService.truncateEpochFilePrefix(1570L);
        this.checkMessage(broker2MessageStore, topic, 10, 10);
        BrokerController broker4 = this.startBroker(nameserverAddress, controllerAddress, brokerName, 4, AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), AutoSwitchRoleIntegrationTest.nextPort(), BrokerRole.SLAVE, 1700);
        this.waitSlaveReady(broker4.getMessageStore());
        this.checkMessage(broker4.getMessageStore(), topic, 10, 10);
        this.shutdownAndClearBroker();
    }

    public void shutdownAndClearBroker() throws InterruptedException {
        for (BrokerController controller : brokerList) {
            controller.shutdown();
            UtilAll.deleteFile((File)new File(controller.getMessageStoreConfig().getStorePathRootDir()));
        }
        brokerList.clear();
    }

    @AfterClass
    public static void destroy() {
        if (namesrvController != null) {
            namesrvController.shutdown();
        }
        if (controllerManager != null) {
            controllerManager.shutdown();
        }
        File file = new File(STORE_PATH_ROOT_PARENT_DIR);
        UtilAll.deleteFile((File)file);
    }
}

