/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.autoswitchrole;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.FlushDiskType;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.awaitility.Awaitility;
import org.junit.Assert;

public class AutoSwitchRoleBase {
    protected static final String STORE_PATH_ROOT_PARENT_DIR = System.getProperty("user.home") + File.separator + UUID.randomUUID().toString().replace("-", "");
    private static final String STORE_PATH_ROOT_DIR = STORE_PATH_ROOT_PARENT_DIR + File.separator + "store";
    private static final String STORE_MESSAGE = "Once, there was a chance for me!";
    private static final byte[] MESSAGE_BODY = "Once, there was a chance for me!".getBytes();
    protected static List<BrokerController> brokerList;
    private static SocketAddress bornHost;
    private static SocketAddress storeHost;
    private static int number;

    protected static void initialize() {
        brokerList = new ArrayList<BrokerController>();
        try {
            storeHost = new InetSocketAddress(InetAddress.getLocalHost(), 8123);
            bornHost = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int nextPort() throws IOException {
        return AutoSwitchRoleBase.nextPort(1001, 9999);
    }

    public static int nextPort(int minPort, int maxPort) throws IOException {
        int port;
        Random random = new Random();
        while (true) {
            try {
                int tempPort = random.nextInt(maxPort) % (maxPort - minPort + 1) + minPort;
                ServerSocket serverSocket = new ServerSocket(tempPort);
                port = serverSocket.getLocalPort();
                serverSocket.close();
            }
            catch (IOException ignored) {
                if (number > 200) {
                    throw new IOException("This server's open ports are temporarily full!");
                }
                ++number;
                continue;
            }
            break;
        }
        number = 0;
        return port;
    }

    public BrokerController startBroker(String namesrvAddress, String controllerAddress, String brokerName, int brokerId, int haPort, int brokerListenPort, int nettyListenPort, BrokerRole expectedRole, int mappedFileSize) throws Exception {
        MessageStoreConfig storeConfig = this.buildMessageStoreConfig(brokerName + "#" + brokerId, haPort, mappedFileSize);
        storeConfig.setHaMaxTimeSlaveNotCatchup(3000L);
        BrokerConfig brokerConfig = new BrokerConfig();
        brokerConfig.setListenPort(brokerListenPort);
        brokerConfig.setNamesrvAddr(namesrvAddress);
        brokerConfig.setControllerAddr(controllerAddress);
        brokerConfig.setSyncBrokerMetadataPeriod(2000L);
        brokerConfig.setCheckSyncStateSetPeriod(2000L);
        brokerConfig.setBrokerName(brokerName);
        brokerConfig.setEnableControllerMode(true);
        NettyServerConfig nettyServerConfig = new NettyServerConfig();
        nettyServerConfig.setListenPort(nettyListenPort);
        BrokerController brokerController = new BrokerController(brokerConfig, nettyServerConfig, new NettyClientConfig(), storeConfig);
        Assert.assertTrue((boolean)brokerController.initialize());
        brokerController.start();
        brokerList.add(brokerController);
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).until(() -> expectedRole == BrokerRole.SYNC_MASTER == brokerController.getReplicasManager().isMasterState());
        return brokerController;
    }

    protected MessageStoreConfig buildMessageStoreConfig(String brokerDir, int haPort, int mappedFileSize) {
        MessageStoreConfig storeConfig = new MessageStoreConfig();
        storeConfig.setHaSendHeartbeatInterval(1000);
        storeConfig.setBrokerRole(BrokerRole.SLAVE);
        storeConfig.setHaListenPort(haPort);
        storeConfig.setStorePathRootDir(STORE_PATH_ROOT_DIR + File.separator + brokerDir);
        storeConfig.setStorePathCommitLog(STORE_PATH_ROOT_DIR + File.separator + brokerDir + File.separator + "commitlog");
        storeConfig.setStorePathEpochFile(STORE_PATH_ROOT_DIR + File.separator + brokerDir + File.separator + "EpochFileCache");
        storeConfig.setStorePathBrokerIdentity(STORE_PATH_ROOT_DIR + File.separator + brokerDir + File.separator + "brokerIdentity");
        storeConfig.setTotalReplicas(3);
        storeConfig.setInSyncReplicas(2);
        storeConfig.setMappedFileSizeCommitLog(mappedFileSize);
        storeConfig.setMappedFileSizeConsumeQueue(0x100000);
        storeConfig.setMaxHashSlotNum(10000);
        storeConfig.setMaxIndexNum(10000);
        storeConfig.setFlushDiskType(FlushDiskType.SYNC_FLUSH);
        storeConfig.setFlushIntervalConsumeQueue(1);
        return storeConfig;
    }

    protected static ControllerConfig buildControllerConfig(String id, String peers) {
        ControllerConfig config = new ControllerConfig();
        config.setControllerDLegerGroup("group1");
        config.setControllerDLegerPeers(peers);
        config.setControllerDLegerSelfId(id);
        config.setMappedFileSize(0x100000);
        config.setControllerStorePath(STORE_PATH_ROOT_DIR + File.separator + "namesrv" + id + File.separator + "DLedgerController");
        return config;
    }

    protected MessageExtBrokerInner buildMessage(String topic) {
        MessageExtBrokerInner msg = new MessageExtBrokerInner();
        msg.setTopic(topic);
        msg.setTags("TAG1");
        msg.setBody(MESSAGE_BODY);
        msg.setKeys(String.valueOf(System.currentTimeMillis()));
        msg.setQueueId(0);
        msg.setSysFlag(0);
        msg.setBornTimestamp(System.currentTimeMillis());
        msg.setStoreHost(storeHost);
        msg.setBornHost(bornHost);
        msg.setPropertiesString(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
        return msg;
    }

    protected void putMessage(MessageStore messageStore, String topic) {
        for (int i = 0; i < 10; ++i) {
            Assert.assertSame((Object)messageStore.putMessage(this.buildMessage(topic)).getPutMessageStatus(), (Object)PutMessageStatus.PUT_OK);
        }
    }

    protected void checkMessage(MessageStore messageStore, String topic, int totalNums, int startOffset) {
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
            GetMessageResult result = messageStore.getMessage("GROUP_A", topic, 0, (long)startOffset, 1024, null);
            return result != null && result.getStatus() == GetMessageStatus.FOUND && result.getMessageCount() >= totalNums;
        });
    }

    static {
        number = 0;
    }
}

