/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.configurable.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.rocketmq.streams.common.configurable.AbstractConfigurable;
import org.apache.rocketmq.streams.common.configurable.IConfigurable;
import org.apache.rocketmq.streams.common.configurable.IConfigurableService;
import org.apache.rocketmq.streams.common.utils.ReflectUtil;
import org.apache.rocketmq.streams.configurable.service.AbstractConfigurableService;

public class MemoryConfigureService
extends AbstractConfigurableService {
    private static Map<String, List<IConfigurable>> namespace2Configure = new HashMap<String, List<IConfigurable>>();

    public MemoryConfigureService(Properties properties) {
        super(properties);
    }

    @Override
    protected AbstractConfigurableService.GetConfigureResult loadConfigurable(String namespace) {
        AbstractConfigurableService.GetConfigureResult result = new AbstractConfigurableService.GetConfigureResult(this);
        result.setQuerySuccess(true);
        ArrayList<IConfigurable> configurableList = new ArrayList<IConfigurable>();
        List<IConfigurable> configurables = namespace2Configure.get(namespace);
        if (configurables == null) {
            configurableList = null;
        } else {
            ArrayList<IConfigurable> tmps = new ArrayList<IConfigurable>();
            tmps.addAll(configurables);
            for (IConfigurable configurable : tmps) {
                IConfigurable tmp = (IConfigurable)ReflectUtil.forInstance(configurable.getClass());
                tmp.toObject(configurable.toJson());
                tmp.setNameSpace(configurable.getNameSpace());
                tmp.setConfigureName(configurable.getConfigureName());
                configurableList.add(tmp);
            }
        }
        result.setConfigurables(configurableList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertConfigurable(IConfigurable configurable) {
        if (configurable == null) {
            return;
        }
        String namespace = configurable.getNameSpace();
        List<IConfigurable> list = namespace2Configure.get(namespace);
        if (list == null) {
            MemoryConfigureService memoryConfigureService = this;
            synchronized (memoryConfigureService) {
                list = namespace2Configure.get(namespace);
                if (list == null) {
                    list = new ArrayList<IConfigurable>();
                    namespace2Configure.put(namespace, list);
                }
            }
        }
        int removeIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            IConfigurable config = list.get(i);
            if (!config.getType().equals(configurable.getType()) || !config.getConfigureName().equals(configurable.getConfigureName())) continue;
            removeIndex = i;
        }
        if (AbstractConfigurable.class.isInstance(configurable)) {
            ((AbstractConfigurable)configurable).setConfigurableService((IConfigurableService)this);
        }
        if (removeIndex != -1) {
            list.remove(removeIndex);
        }
        list.add(configurable);
    }

    @Override
    protected void updateConfigurable(IConfigurable configure) {
        List<IConfigurable> list = namespace2Configure.get(configure.getNameSpace());
        if (list == null || list.size() == 0) {
            throw new RuntimeException("not have exist configure " + configure.getNameSpace() + "," + configure.getType() + "," + configure.getConfigureName());
        }
        for (int i = 0; i < list.size(); ++i) {
            IConfigurable config = list.get(i);
            if (!config.getType().equals(configure.getType()) || !config.getConfigureName().equals(configure.getConfigureName())) continue;
            list.set(i, configure);
            return;
        }
        throw new RuntimeException("not have exist configure " + configure.getNameSpace() + "," + configure.getType() + "," + configure.getConfigureName());
    }

    public <T extends IConfigurable> List<T> loadConfigurableFromStorage(String type) {
        this.refreshConfigurable(this.getNamespace());
        return this.queryConfigurableByType(type);
    }
}

