/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.configurable.service.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rocketmq.streams.common.component.ComponentCreator;
import org.apache.rocketmq.streams.common.configurable.IConfigurable;
import org.apache.rocketmq.streams.common.model.Entity;
import org.apache.rocketmq.streams.common.utils.AESUtil;
import org.apache.rocketmq.streams.common.utils.DateUtil;
import org.apache.rocketmq.streams.common.utils.FileUtil;
import org.apache.rocketmq.streams.common.utils.MapKeyUtil;
import org.apache.rocketmq.streams.common.utils.StringUtil;
import org.apache.rocketmq.streams.configurable.model.Configure;
import org.apache.rocketmq.streams.configurable.service.AbstractConfigurableService;

public class FileConfigureService
extends AbstractConfigurableService {
    public static final String FILE_PATH_NAME = "filePathAndName";
    private static final Log LOG = LogFactory.getLog(FileConfigureService.class);
    private static final String DEFAULT_FILE_NAME = "dipper.cs";
    private static final String SIGN = "&&&&";
    public String fileName;

    public FileConfigureService(Properties properties) {
        super(properties);
        this.initService(properties.getProperty(FILE_PATH_NAME));
    }

    protected void initService(String fileAndPath) {
        if (StringUtil.isEmpty((String)fileAndPath)) {
            String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            if (path.endsWith(".jar")) {
                int index = path.lastIndexOf(File.separator);
                path = path.substring(0, index);
            }
            this.fileName = FileUtil.concatFilePath((String)path, (String)DEFAULT_FILE_NAME);
        } else {
            this.fileName = fileAndPath;
        }
        LOG.info((Object)("load file from path = " + this.fileName));
    }

    @Override
    protected AbstractConfigurableService.GetConfigureResult loadConfigurable(String namespace) {
        AbstractConfigurableService.GetConfigureResult result = new AbstractConfigurableService.GetConfigureResult();
        try {
            List<Configure> configures = this.selectOpening(namespace);
            List<IConfigurable> configurables = this.convert(configures);
            LOG.info((Object)("load configure namespace=" + namespace + " count=" + configures.size()));
            result.setConfigurables(configurables);
            result.setQuerySuccess(true);
        }
        catch (Exception e) {
            result.setQuerySuccess(false);
            e.printStackTrace();
            LOG.error((Object)"load configurable error ", (Throwable)e);
        }
        return result;
    }

    protected List<Configure> selectOpening(String namespace) {
        List<String> list = this.loadFileLine(this.fileName);
        List<Configure> configures = this.convert2Configure(list);
        return this.filter(configures, namespace);
    }

    protected List<Configure> filter(List<Configure> configures, String namespace) {
        if (configures == null) {
            return new ArrayList<Configure>();
        }
        if (StringUtil.isEmpty((String)namespace)) {
            throw new RuntimeException("namespace can not empty ");
        }
        ArrayList<Configure> filterConfigures = new ArrayList<Configure>();
        for (Configure configure : configures) {
            if (!namespace.equals(configure.getNameSpace())) continue;
            filterConfigures.add(configure);
        }
        return filterConfigures;
    }

    @Override
    protected void insertConfigurable(IConfigurable configure) {
        if (configure == null) {
            LOG.warn((Object)"insert configure is null");
            return;
        }
        String row = this.configure2String(configure);
        List<String> rows = this.loadFileLine(this.fileName);
        if (rows == null) {
            rows = new ArrayList<String>();
        }
        List<Configure> configures = this.convert2Configure(rows);
        String newKey = MapKeyUtil.createKey((String[])new String[]{configure.getNameSpace(), configure.getType(), configure.getConfigureName()});
        boolean isReplace = false;
        for (int i = 0; i < configures.size(); ++i) {
            Configure c = configures.get(i);
            String old = MapKeyUtil.createKey((String[])new String[]{c.getNameSpace(), c.getType(), c.getName()});
            if (!old.equals(newKey)) continue;
            rows.set(i, this.configure2String(configure));
            isReplace = true;
            break;
        }
        if (!isReplace) {
            rows.add(this.configure2String(configure));
        }
        this.writeFile(this.fileName, rows);
    }

    @Override
    protected void updateConfigurable(IConfigurable configure) {
        if (configure == null) {
            LOG.warn((Object)"insert configure is null");
            return;
        }
        ArrayList<String> rows = FileUtil.loadFileLine((String)this.fileName);
        if (rows == null) {
            rows = new ArrayList<String>();
        }
        for (int i = 0; i < rows.size(); ++i) {
            String row = (String)rows.get(i);
            Configure oldConfigure = this.convert(row);
            if (!configure.getNameSpace().equals(oldConfigure.getNameSpace()) || !configure.getType().equals(oldConfigure.getType()) || !configure.getConfigureName().equals(oldConfigure.getName())) continue;
            rows.set(i, this.configure2String(configure));
        }
        this.writeFile(this.fileName, rows);
    }

    protected Configure convert(String row) {
        String[] values = row.split(SIGN);
        String namespace = this.getColumnValue(values, 0, "namespace");
        String type = this.getColumnValue(values, 1, "type");
        String name = this.getColumnValue(values, 2, "name");
        String jsonValue = this.getColumnValue(values, 3, "json_value");
        try {
            jsonValue = AESUtil.aesDecrypt((String)jsonValue, (String)ComponentCreator.getProperties().getProperty("dipper.configure.sec.key", "93ea4211-6218-4353-b9cd-1d21618dbf4e"));
        }
        catch (Exception e) {
            LOG.error((Object)("failed in decrypting the value, reason:\t" + e.getCause()));
            throw new RuntimeException(e);
        }
        String createDate = this.getColumnValue(values, 4, "gmt_create");
        String modifiedDate = this.getColumnValue(values, 5, "gmt_modified");
        String id = this.getColumnValue(values, 6, "id");
        Configure configure = new Configure();
        configure.setNameSpace(namespace);
        configure.setType(type);
        configure.setName(name);
        configure.setJsonValue(jsonValue);
        configure.setGmtCreate(DateUtil.parse((String)createDate));
        configure.setGmtCreate(DateUtil.parse((String)modifiedDate));
        configure.setId(id == null ? null : Long.valueOf(id));
        return configure;
    }

    protected List<Configure> convert2Configure(List<String> rows) {
        ArrayList<Configure> configures = new ArrayList<Configure>();
        for (String row : rows) {
            configures.add(this.convert(row));
        }
        return configures;
    }

    protected String getColumnValue(String[] values, int i, String namespace) {
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length <= i) {
            return null;
        }
        if ("null".equals(values[i])) {
            return null;
        }
        return values[i];
    }

    protected List<String> loadFileLine(String fileName) {
        ArrayList rows = FileUtil.loadFileLine((String)fileName);
        if (rows == null) {
            rows = new ArrayList();
        }
        return this.doDecRowList(rows);
    }

    protected void writeFile(String fileName, List<String> rows) {
        List<String> rowList = this.doEncryptRowList(rows);
        FileUtil.write((String)fileName, rowList);
    }

    private List<String> doEncryptRowList(List<String> rows) {
        return rows;
    }

    private List<String> doDecRowList(List<String> rows) {
        return rows;
    }

    protected String configure2String(IConfigurable configure) {
        Entity entity = null;
        entity = configure instanceof Entity ? (Entity)configure : new Entity();
        String theSecretValue = null;
        try {
            theSecretValue = AESUtil.aesEncrypt((String)configure.toJson(), (String)ComponentCreator.getProperties().getProperty("dipper.configure.sec.key", "93ea4211-6218-4353-b9cd-1d21618dbf4e"));
        }
        catch (Exception e) {
            LOG.error((Object)("failed in encrypting the value, reason:\t" + e.getCause()));
            throw new RuntimeException(e);
        }
        String row = MapKeyUtil.createKeyBySign((String)SIGN, (String[])new String[]{configure.getNameSpace(), configure.getType(), configure.getConfigureName(), theSecretValue, DateUtil.format((Date)entity.getGmtCreate()), DateUtil.format((Date)entity.getGmtModified()), entity.getId() + ""});
        return row;
    }

    public String getFileName() {
        return this.fileName;
    }

    public <T extends IConfigurable> List<T> loadConfigurableFromStorage(String type) {
        this.refreshConfigurable(this.getNamespace());
        return this.queryConfigurableByType(type);
    }
}

