/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.configurable.service;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rocketmq.streams.common.configurable.IConfigurableService;
import org.apache.rocketmq.streams.common.utils.ReflectUtil;
import org.apache.rocketmq.streams.common.utils.StringUtil;
import org.apache.rocketmq.streams.configurable.service.AbstractSupportParentConfigureService;
import org.apache.rocketmq.streams.serviceloader.ServiceLoaderComponent;

public class ConfigurableServiceFactory {
    private static ServiceLoaderComponent<IConfigurableService> configurableServiceLoaderComponent = ServiceLoaderComponent.getInstance(IConfigurableService.class);
    public static final String CONFIGURABLE_SERVICE_TYPE = "dipper.configurable.service.type";
    private static final Log LOG = LogFactory.getLog(ConfigurableServiceFactory.class);

    public static IConfigurableService createConfigurableService(Properties properties) {
        try {
            IConfigurableService configurableService;
            Properties properties1 = new Properties();
            properties1.putAll((Map<?, ?>)properties);
            String type = properties1.getProperty(CONFIGURABLE_SERVICE_TYPE);
            if (StringUtil.isEmpty((String)type)) {
                type = "memory";
            }
            if ((configurableService = ConfigurableServiceFactory.getConfigurableServiceType(type)) instanceof AbstractSupportParentConfigureService) {
                ((AbstractSupportParentConfigureService)configurableService).initMethod(properties1);
            }
            return configurableService;
        }
        catch (Exception e) {
            LOG.error((Object)"create ConfigurableService error", (Throwable)e);
            return null;
        }
    }

    public static IConfigurableService getConfigurableServiceType(String type) {
        IConfigurableService configurableService = (IConfigurableService)configurableServiceLoaderComponent.getService().loadService(type);
        return (IConfigurableService)ReflectUtil.forInstance((String)configurableService.getClass().getName());
    }
}

