/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.configurable.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rocketmq.streams.common.configurable.IConfigurable;
import org.apache.rocketmq.streams.common.configurable.IConfigurableService;
import org.apache.rocketmq.streams.common.utils.StringUtil;
import org.apache.rocketmq.streams.configurable.service.AbstractConfigurableService;
import org.apache.rocketmq.streams.configurable.service.ConfigurableServiceFactory;

public abstract class AbstractSupportParentConfigureService
extends AbstractConfigurableService
implements IConfigurableService {
    private static final Log LOG = LogFactory.getLog(AbstractSupportParentConfigureService.class);
    protected IConfigurableService configureService = null;
    protected IConfigurableService parentConfigureService = null;
    protected Properties properties;

    public AbstractSupportParentConfigureService() {
        super(null);
    }

    public void initMethod(Properties property) {
        this.properties = property;
        this.initBeforeInitConfigurable(property);
    }

    protected abstract void initBeforeInitConfigurable(Properties var1);

    @Override
    public void initConfigurables(String namespace) {
        if (!"rocketmq.streams.root.namespace".equals(namespace)) {
            this.parentConfigureService.initConfigurables("rocketmq.streams.root.namespace");
        } else {
            this.parentConfigureService = null;
        }
        this.configureService.initConfigurables(namespace);
    }

    @Override
    public boolean refreshConfigurable(String namespace) {
        if (!"rocketmq.streams.root.namespace".equals(namespace)) {
            this.parentConfigureService.refreshConfigurable("rocketmq.streams.root.namespace");
        }
        this.configureService.refreshConfigurable(namespace);
        return true;
    }

    @Override
    public List<IConfigurable> queryConfigurable(String type) {
        ArrayList<IConfigurable> result = this.configureService.queryConfigurable(type);
        if (result == null) {
            result = new ArrayList<IConfigurable>();
        }
        if (this.parentConfigureService == null) {
            return result;
        }
        List parent = this.parentConfigureService.queryConfigurable(type);
        if (parent != null) {
            result.addAll(parent);
        }
        return result;
    }

    @Override
    public IConfigurable queryConfigurableByIdent(String type, String name) {
        IConfigurable configurable = this.configureService.queryConfigurableByIdent(type, name);
        if (configurable != null) {
            return configurable;
        }
        if (this.parentConfigureService == null) {
            return null;
        }
        if (configurable != null) {
            return configurable;
        }
        return this.parentConfigureService.queryConfigurableByIdent(type, name);
    }

    @Override
    public IConfigurable queryConfigurableByIdent(String identification) {
        IConfigurable configurable = this.configureService.queryConfigurableByIdent(identification);
        if (configurable != null) {
            return configurable;
        }
        if (this.parentConfigureService == null) {
            return null;
        }
        if (configurable != null) {
            return configurable;
        }
        return this.parentConfigureService.queryConfigurableByIdent(identification);
    }

    @Override
    protected void insertConfigurable(IConfigurable configurable) {
        if (this.parentConfigureService != null && configurable.getNameSpace().equals("rocketmq.streams.root.namespace")) {
            this.parentConfigureService.insert(configurable);
        } else {
            this.configureService.insert(configurable);
        }
    }

    @Override
    protected void updateConfigurable(IConfigurable configurable) {
        if (this.parentConfigureService != null && configurable.getNameSpace().equals("rocketmq.streams.root.namespace")) {
            this.parentConfigureService.update(configurable);
        } else {
            this.configureService.update(configurable);
        }
    }

    @Override
    public <T> T queryConfigurable(String configurableType, String name) {
        return (T)this.queryConfigurableByIdent(configurableType, name);
    }

    @Override
    protected AbstractConfigurableService.GetConfigureResult loadConfigurable(String namespace) {
        return null;
    }

    protected List<IConfigurable> createAndQueryConfigurable(String sharedNameSpace, String sharedType, String sharedName) {
        IConfigurableService innerSharedConfigurableService = ConfigurableServiceFactory.createConfigurableService(this.properties);
        innerSharedConfigurableService.refreshConfigurable(sharedNameSpace);
        if (StringUtil.isNotEmpty((String)sharedName)) {
            ArrayList<IConfigurable> configurables = new ArrayList<IConfigurable>();
            IConfigurable configurable = innerSharedConfigurableService.queryConfigurableByIdent(sharedType, sharedName);
            configurables.add(configurable);
            return configurables;
        }
        return innerSharedConfigurableService.queryConfigurable(sharedType);
    }

    @Override
    public Collection<IConfigurable> findAll() {
        Collection tmp;
        ArrayList<IConfigurable> configurables = new ArrayList<IConfigurable>();
        if (this.parentConfigureService != null && ((tmp = this.parentConfigureService.findAll()) != null || tmp.size() > 0)) {
            configurables.addAll(tmp);
        }
        if ((tmp = this.configureService.findAll()) != null || tmp.size() > 0) {
            configurables.addAll(tmp);
        }
        return configurables;
    }

    public IConfigurableService getConfigureService() {
        return this.configureService;
    }

    public <T extends IConfigurable> List<T> loadConfigurableFromStorage(String type) {
        List tmp;
        ArrayList configurables = new ArrayList();
        if (this.parentConfigureService != null && ((tmp = this.parentConfigureService.loadConfigurableFromStorage(type)) != null || tmp.size() > 0)) {
            configurables.addAll(tmp);
        }
        if ((tmp = this.configureService.loadConfigurableFromStorage(type)) != null || tmp.size() > 0) {
            configurables.addAll(tmp);
        }
        return configurables;
    }
}

