/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.configurable.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rocketmq.streams.common.configurable.AbstractConfigurable;
import org.apache.rocketmq.streams.common.configurable.IAfterConfigurableRefreshListener;
import org.apache.rocketmq.streams.common.configurable.IConfigurable;
import org.apache.rocketmq.streams.common.configurable.IConfigurableService;
import org.apache.rocketmq.streams.common.datatype.DataType;
import org.apache.rocketmq.streams.common.model.Entity;
import org.apache.rocketmq.streams.common.utils.ConfigurableUtil;
import org.apache.rocketmq.streams.common.utils.DataTypeUtil;
import org.apache.rocketmq.streams.common.utils.MapKeyUtil;
import org.apache.rocketmq.streams.common.utils.ReflectUtil;
import org.apache.rocketmq.streams.common.utils.StringUtil;
import org.apache.rocketmq.streams.configurable.model.Configure;

public abstract class AbstractConfigurableService
implements IConfigurableService {
    private static final Log LOG = LogFactory.getLog(AbstractConfigurableService.class);
    private static final String CLASS_NAME = "className";
    protected Map<String, List<IConfigurable>> type2ConfigurableMap = new HashMap<String, List<IConfigurable>>();
    protected Map<String, IConfigurable> name2ConfigurableMap = new HashMap<String, IConfigurable>();
    protected Map<String, IConfigurable> configurableMap = new HashMap<String, IConfigurable>();
    protected Properties properties;
    protected transient String namespace;
    private ScheduledExecutorService scheduledExecutorService;

    public AbstractConfigurableService(Properties properties) {
        this.properties = properties;
    }

    public AbstractConfigurableService() {
    }

    public IConfigurable queryConfigurableByIdent(String identification) {
        return this.name2ConfigurableMap.get(identification);
    }

    protected String getConfigureKey(String nameSpace, String type, String name) {
        return MapKeyUtil.createKey((String[])new String[]{nameSpace, type, name});
    }

    protected void updateConfiguresCache(IConfigurable configurable) {
        if (configurable == null) {
            return;
        }
        configurable.toJson();
        String key = this.getConfigureKey(configurable.getNameSpace(), configurable.getType(), configurable.getConfigureName());
        this.configurableMap.put(key, configurable);
    }

    protected void updateConfiguresCache(List<IConfigurable> configureList) {
        for (IConfigurable iConfigurable : configureList) {
            this.updateConfiguresCache(iConfigurable);
        }
    }

    protected boolean equals(String key, List<?> newConfigureList) {
        for (Object o : newConfigureList) {
            IConfigurable oldConfigure;
            IConfigurable configure = (IConfigurable)o;
            String tempKey = this.getConfigureKey(configure.getNameSpace(), configure.getType(), configure.getConfigureName());
            if (!key.equals(tempKey) || (oldConfigure = this.configurableMap.get(key)) == null) continue;
            return ConfigurableUtil.compare((IConfigurable)oldConfigure, (IConfigurable)configure);
        }
        return false;
    }

    public <T extends IConfigurable> List<T> queryConfigurableByType(String type) {
        List<IConfigurable> list = this.queryConfigurable(type);
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<IConfigurable> result = new ArrayList<IConfigurable>();
        for (IConfigurable configurable : list) {
            result.add(configurable);
        }
        return result;
    }

    public boolean refreshConfigurable(String namespace) {
        this.namespace = namespace;
        HashMap<String, List<IConfigurable>> tempType2ConfigurableMap = new HashMap<String, List<IConfigurable>>();
        HashMap<String, IConfigurable> tempName2ConfigurableMap = new HashMap<String, IConfigurable>();
        GetConfigureResult configures = this.loadConfigurable(namespace);
        if (configures != null && configures.isQuerySuccess() && configures.getConfigurables() != null) {
            List<IConfigurable> configurables = configures.getConfigurables();
            List<IConfigurable> configurableList = this.checkAndUpdateConfigurables(configurables, tempType2ConfigurableMap, tempName2ConfigurableMap);
            for (IConfigurable configurable : configurableList) {
                if (!(configurable instanceof IAfterConfigurableRefreshListener)) continue;
                ((IAfterConfigurableRefreshListener)configurable).doProcessAfterRefreshConfigurable((IConfigurableService)this);
            }
            return true;
        }
        return false;
    }

    public <T> T queryConfigurable(String configurableType, String name) {
        return (T)this.queryConfigurableByIdent(configurableType, name);
    }

    protected List<IConfigurable> checkAndUpdateConfigurables(List<IConfigurable> configurables, Map<String, List<IConfigurable>> tempType2ConfigurableMap, Map<String, IConfigurable> tempName2ConfigurableMap) {
        ArrayList<IConfigurable> configurableList = new ArrayList<IConfigurable>();
        for (IConfigurable configurable : configurables) {
            try {
                boolean isUpdate = this.update(configurable, tempName2ConfigurableMap, tempType2ConfigurableMap);
                if (!isUpdate) continue;
                configurableList.add(configurable);
            }
            catch (Exception e) {
                LOG.error((Object)("\u7ec4\u4ef6\u521d\u59cb\u5316\u5f02\u5e38\uff1a" + e.getMessage() + ",name=" + configurable.getConfigureName()), (Throwable)e);
            }
        }
        this.destroyOldConfigurables(tempName2ConfigurableMap);
        this.name2ConfigurableMap = tempName2ConfigurableMap;
        this.type2ConfigurableMap = tempType2ConfigurableMap;
        return configurableList;
    }

    private void destroyOldConfigurables(Map<String, IConfigurable> tempName2ConfigurableMap) {
        for (Map.Entry<String, IConfigurable> entry : this.name2ConfigurableMap.entrySet()) {
            String key = entry.getKey();
            IConfigurable value = entry.getValue();
            if (tempName2ConfigurableMap.containsKey(key)) continue;
            this.destroyOldConfigurable(value);
        }
    }

    private void destroyOldConfigurable(IConfigurable oldConfigurable) {
        if (oldConfigurable instanceof AbstractConfigurable) {
            ((AbstractConfigurable)oldConfigurable).destroy();
        }
        String key = this.getConfigureKey(oldConfigurable.getNameSpace(), oldConfigurable.getType(), oldConfigurable.getConfigureName());
        this.configurableMap.remove(key);
    }

    protected void initConfigurable(IConfigurable configurable) {
        if (configurable instanceof AbstractConfigurable) {
            AbstractConfigurable abstractConfigurable = (AbstractConfigurable)configurable;
            abstractConfigurable.setConfigurableService((IConfigurableService)this);
        }
        configurable.init();
    }

    public void initConfigurables(final String namespace) {
        String pollingTimeStr;
        this.refreshConfigurable(namespace);
        long polingTime = -1L;
        if (this.properties != null && StringUtil.isNotEmpty((String)(pollingTimeStr = this.properties.getProperty("dipper.configurable.polling.time")))) {
            polingTime = Long.valueOf(pollingTimeStr);
        }
        if (polingTime > 0L) {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(3);
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractConfigurableService.this.refreshConfigurable(namespace);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Load configurables error:" + e.getMessage()), (Throwable)e);
                    }
                }
            }, polingTime, polingTime, TimeUnit.SECONDS);
        }
    }

    public List<IConfigurable> queryConfigurable(String type) {
        String key = MapKeyUtil.createKey((String[])new String[]{type});
        return this.type2ConfigurableMap.get(key);
    }

    public IConfigurable queryConfigurableByIdent(String type, String name) {
        String key = MapKeyUtil.createKey((String[])new String[]{type, name});
        return this.name2ConfigurableMap.get(key);
    }

    protected abstract GetConfigureResult loadConfigurable(String var1);

    public void update(IConfigurable configurable) {
        this.updateConfigurable(configurable);
    }

    protected abstract void updateConfigurable(IConfigurable var1);

    protected abstract void insertConfigurable(IConfigurable var1);

    protected boolean update(IConfigurable configurable, Map<String, IConfigurable> name2ConfigurableMap, Map<String, List<IConfigurable>> type2ConfigurableMap) {
        if (configurable == null) {
            return false;
        }
        boolean isUpdate = false;
        ArrayList<IConfigurable> configurableList = new ArrayList<IConfigurable>();
        configurableList.add(configurable);
        String nameKey = MapKeyUtil.createKey((String[])new String[]{configurable.getType(), configurable.getConfigureName()});
        if (this.name2ConfigurableMap.containsKey(nameKey)) {
            String configureKey = this.getConfigureKey(this.namespace, configurable.getType(), configurable.getConfigureName());
            IConfigurable oldConfigurable = this.name2ConfigurableMap.get(nameKey);
            if (this.equals(configureKey, configurableList)) {
                configurable = oldConfigurable;
            } else {
                this.destroyOldConfigurable(oldConfigurable);
                this.initConfigurable(configurable);
                isUpdate = true;
            }
        } else {
            this.initConfigurable(configurable);
            isUpdate = true;
        }
        this.updateConfiguresCache(configurable);
        name2ConfigurableMap.put(nameKey, configurable);
        String typeKey = MapKeyUtil.createKey((String[])new String[]{configurable.getType()});
        this.put2Map(type2ConfigurableMap, typeKey, configurable);
        return isUpdate;
    }

    public void insert(IConfigurable configurable) {
        this.insertConfigurable(configurable);
    }

    public List<IConfigurable> queryConfiguableByNamespace(String ... namespaces) {
        ArrayList<IConfigurable> configurables = new ArrayList<IConfigurable>();
        if (namespaces == null || namespaces.length == 0) {
            return configurables;
        }
        for (String namespace : namespaces) {
            GetConfigureResult result = this.loadConfigurable(namespace);
            if (result.querySuccess) {
                if (result.configurables == null || result.configurables.size() <= 0) continue;
                configurables.addAll(result.configurables);
                continue;
            }
            throw new RuntimeException("Load configurable error, the namespace is " + namespace);
        }
        return configurables;
    }

    protected void put2Map(Map<String, List<IConfigurable>> map, String key, IConfigurable configurable) {
        List<IConfigurable> list = map.get(key);
        if (list == null) {
            list = new ArrayList<IConfigurable>();
            map.put(key, list);
        }
        list.add(configurable);
    }

    public Collection<IConfigurable> findAll() {
        return this.name2ConfigurableMap.values();
    }

    protected Configure createConfigure(IConfigurable configurable) {
        Configure configure = new Configure();
        configure.setType(configurable.getType());
        configure.setName(configurable.getConfigureName());
        configure.setNameSpace(configurable.getNameSpace());
        String jsonString = configurable.toJson();
        if (!StringUtil.isEmpty((String)jsonString)) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            jsonObject.put(CLASS_NAME, (Object)configurable.getClass().getName());
            configure.setJsonValue(jsonObject.toJSONString());
        }
        return configure;
    }

    public <T> Map<String, T> queryConfigurableMapByType(String type) {
        List<IConfigurable> configurables = this.queryConfigurable(type);
        if (configurables == null) {
            return new HashMap();
        }
        HashMap<String, IConfigurable> result = new HashMap<String, IConfigurable>();
        for (IConfigurable configurable : configurables) {
            result.put(configurable.getConfigureName(), configurable);
        }
        return result;
    }

    protected List<IConfigurable> convert(List<Configure> configures) {
        if (configures == null) {
            return new ArrayList<IConfigurable>();
        }
        ArrayList<IConfigurable> configurables = new ArrayList<IConfigurable>();
        for (Configure configure : configures) {
            IConfigurable configurable = this.convert(configure);
            if (configurable == null) continue;
            configurables.add(configurable);
        }
        return configurables;
    }

    protected IConfigurable createConfigurableFromJson(String namespace, String type, String name, String jsonValue) {
        if (StringUtil.isEmpty((String)jsonValue)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)jsonValue);
        String className = jsonObject.getString(CLASS_NAME);
        IConfigurable configurable = this.createConfigurable(className);
        if (configurable == null) {
            return null;
        }
        configurable.setConfigureName(name);
        configurable.setNameSpace(namespace);
        configurable.setType(type);
        if (AbstractConfigurable.class.isInstance(configurable)) {
            AbstractConfigurable abstractConfigurable = (AbstractConfigurable)configurable;
            abstractConfigurable.setConfigurableService((IConfigurableService)this);
        }
        configurable.toObject(jsonValue);
        return configurable;
    }

    protected IConfigurable convert(Configure configure) {
        return this.convertConfigurable(configure);
    }

    protected IConfigurable convertConfigurable(Configure configure) {
        Object className = null;
        try {
            String jsonString = configure.getJsonValue();
            IConfigurable configurable = this.createConfigurableFromJson(configure.getNameSpace(), configure.getType(), configure.getName(), jsonString);
            if (configurable instanceof Entity) {
                Entity abs = (Entity)configurable;
                abs.setId(configure.getId());
                abs.setGmtCreate(configure.getGmtCreate());
                abs.setGmtModified(configure.getGmtModified());
            }
            this.convertPost(configurable);
            return configurable;
        }
        catch (Exception e) {
            LOG.error((Object)("\u8f6c\u6362\u5f02\u5e38\uff1a" + configure.toString()), (Throwable)e);
            return null;
        }
    }

    protected void convertPost(IConfigurable configurable) {
        if (this.properties == null) {
            return;
        }
        String identification = MapKeyUtil.createKey((String[])new String[]{configurable.getNameSpace(), configurable.getType(), configurable.getConfigureName()});
        String propertyValue = this.properties.getProperty(identification);
        if (StringUtil.isEmpty((String)propertyValue)) {
            return;
        }
        String[] fieldName2Values = propertyValue.split(",");
        if (fieldName2Values == null || fieldName2Values.length == 0) {
            return;
        }
        for (String fieldName2Value : fieldName2Values) {
            try {
                String[] fieldName2ValueArray = fieldName2Value.split(":");
                if (fieldName2ValueArray == null || fieldName2ValueArray.length != 2) continue;
                String fieldName = fieldName2ValueArray[0];
                String value = fieldName2ValueArray[1];
                Class clazz = ReflectUtil.getBeanFieldType(configurable.getClass(), (String)fieldName);
                DataType dataType = DataTypeUtil.createDataType((Class)clazz, null);
                if (dataType == null) continue;
                Object fieldValue = dataType.getData(value);
                ReflectUtil.setBeanFieldValue((Object)configurable, (String)fieldName, (Object)fieldValue);
            }
            catch (Exception e) {
                LOG.error((Object)("convert post error " + fieldName2Value), (Throwable)e);
            }
        }
    }

    protected IConfigurable createConfigurable(String className) {
        return (IConfigurable)ReflectUtil.forInstance((String)className);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public class GetConfigureResult {
        private boolean querySuccess;
        private List<IConfigurable> configurables;

        public boolean isQuerySuccess() {
            return this.querySuccess;
        }

        public void setQuerySuccess(boolean querySuccess) {
            this.querySuccess = querySuccess;
        }

        public List<IConfigurable> getConfigurables() {
            return this.configurables;
        }

        public void setConfigurables(List<IConfigurable> configurables) {
            this.configurables = configurables;
        }
    }
}

