/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.configurable;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rocketmq.streams.common.component.AbstractComponent;
import org.apache.rocketmq.streams.common.component.ComponentCreator;
import org.apache.rocketmq.streams.common.component.ConfigureDescriptor;
import org.apache.rocketmq.streams.common.configurable.IConfigurable;
import org.apache.rocketmq.streams.common.configurable.IConfigurableService;
import org.apache.rocketmq.streams.common.utils.ConfigurableUtil;
import org.apache.rocketmq.streams.configurable.service.AbstractConfigurableService;
import org.apache.rocketmq.streams.configurable.service.ConfigurableServiceFactory;

public class ConfigurableComponent
extends AbstractComponent<IConfigurableService>
implements IConfigurableService {
    private static final Log LOG = LogFactory.getLog(ConfigurableComponent.class);
    protected volatile IConfigurableService configureService = null;
    protected transient String namespace;

    public ConfigurableComponent() {
        this.initConfigurableServiceDescriptor();
        this.addConfigureDescriptor(new ConfigureDescriptor("dipper.configurable.service.type", false, "DB"));
    }

    public static ConfigurableComponent getInstance(String namespace) {
        return (ConfigurableComponent)ComponentCreator.getComponent((String)namespace, ConfigurableComponent.class);
    }

    protected boolean initProperties(Properties properties) {
        try {
            if (this.configureService != null) {
                return true;
            }
            this.configureService = ConfigurableServiceFactory.createConfigurableService(properties);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("ConfigurableComponent create error,properties= " + properties), (Throwable)e);
            return false;
        }
    }

    public boolean startComponent(String namespace) {
        try {
            this.namespace = namespace;
            this.configureService.initConfigurables(namespace);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("ConfigurableComponent init error, namespace is " + namespace), (Throwable)e);
            return false;
        }
    }

    public static void begineTestMode() {
        System.setProperty("dipper.configurable.service.type", "memory");
    }

    public static void endTestMode() {
        System.clearProperty("dipper.configurable.service.type");
    }

    public boolean stop() {
        return true;
    }

    public IConfigurableService getService() {
        return this.configureService;
    }

    public void initConfigurables(String namespace) {
        this.configureService.initConfigurables(namespace);
    }

    public boolean refreshConfigurable(String namespace) {
        return this.configureService.refreshConfigurable(namespace);
    }

    public void mockConfigurable(String namespace) {
        this.refreshConfigurable(namespace);
    }

    public List<IConfigurable> queryConfigurable(String type) {
        return this.configureService.queryConfigurable(type);
    }

    public <T extends IConfigurable> List<T> queryConfigurableByType(String type) {
        return this.configureService.queryConfigurableByType(type);
    }

    public IConfigurable queryConfigurableByIdent(String type, String name) {
        return this.configureService.queryConfigurableByIdent(type, name);
    }

    public IConfigurable queryConfigurableByIdent(String identification) {
        return this.configureService.queryConfigurableByIdent(identification);
    }

    public void insert(IConfigurable configurable) {
        this.configureService.insert(configurable);
        ConfigurableUtil.refreshMock((IConfigurable)configurable);
    }

    public void update(IConfigurable configurable) {
        this.configureService.update(configurable);
    }

    public <T> Map<String, T> queryConfigurableMapByType(String type) {
        return this.configureService.queryConfigurableMapByType(type);
    }

    public <T> T queryConfigurable(String configurableType, String name) {
        return (T)this.queryConfigurableByIdent(configurableType, name);
    }

    public String getNamespace() {
        if (this.configureService instanceof AbstractConfigurableService) {
            return this.configureService.getNamespace();
        }
        return this.namespace;
    }

    public Collection<IConfigurable> findAll() {
        return this.configureService.findAll();
    }

    public <T extends IConfigurable> List<T> loadConfigurableFromStorage(String type) {
        return this.configureService.loadConfigurableFromStorage(type);
    }
}

