/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.mqtt.source;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.streams.common.channel.source.AbstractBatchSource;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class PahoSource
extends AbstractBatchSource {
    private String url;
    private String clientId;
    private String topic;
    private String username;
    private String password;
    private Boolean cleanSession;
    private Integer connectionTimeout;
    private Integer aliveInterval;
    private Boolean automaticReconnect;
    private transient MqttClient client;

    public PahoSource() {
    }

    public PahoSource(String url, String clientId) {
        this(url, clientId, null);
    }

    public PahoSource(String url, String clientId, String topic) {
        this(url, clientId, topic, null, null);
    }

    public PahoSource(String url, String clientId, String topic, String username, String password) {
        this(url, clientId, topic, username, password, true, 10, 60, true);
    }

    public PahoSource(String url, String clientId, String topic, String username, String password, Boolean cleanSession, Integer connectionTimeout, Integer aliveInterval, Boolean automaticReconnect) {
        this.url = url;
        this.clientId = clientId;
        this.topic = topic;
        this.username = username;
        this.password = password;
        this.cleanSession = cleanSession;
        this.connectionTimeout = connectionTimeout;
        this.aliveInterval = aliveInterval;
        this.automaticReconnect = automaticReconnect;
    }

    protected boolean startSource() {
        try {
            this.client = new MqttClient(this.url, this.clientId, (MqttClientPersistence)new MemoryPersistence());
            this.client.setCallback(new MqttCallback(){

                public void connectionLost(Throwable throwable) {
                    System.out.println("Reconnecting to broker: " + PahoSource.this.url);
                    while (true) {
                        MqttConnectOptions connOpts = new MqttConnectOptions();
                        if (PahoSource.this.username != null && PahoSource.this.password != null) {
                            connOpts.setUserName(PahoSource.this.username);
                            connOpts.setPassword(PahoSource.this.password.toCharArray());
                        }
                        if (PahoSource.this.cleanSession == null) {
                            connOpts.setCleanSession(true);
                        } else {
                            connOpts.setCleanSession(PahoSource.this.cleanSession.booleanValue());
                        }
                        if (PahoSource.this.connectionTimeout == null) {
                            connOpts.setConnectionTimeout(10);
                        } else {
                            connOpts.setConnectionTimeout(PahoSource.this.connectionTimeout.intValue());
                        }
                        if (PahoSource.this.aliveInterval == null) {
                            connOpts.setKeepAliveInterval(60);
                        } else {
                            connOpts.setKeepAliveInterval(PahoSource.this.aliveInterval.intValue());
                        }
                        if (PahoSource.this.automaticReconnect == null) {
                            connOpts.setAutomaticReconnect(true);
                        } else {
                            connOpts.setAutomaticReconnect(PahoSource.this.automaticReconnect.booleanValue());
                        }
                        try {
                            PahoSource.this.client.connect(connOpts);
                            System.out.println("Reconnecting success");
                            PahoSource.this.client.subscribe(PahoSource.this.topic);
                        }
                        catch (MqttException e) {
                            try {
                                System.err.println("Reconnecting err: " + e.getMessage());
                                e.printStackTrace();
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                            continue;
                        }
                        break;
                    }
                }

                public void messageArrived(String s, MqttMessage mqttMessage) throws Exception {
                    JSONObject msg = PahoSource.this.create(new String(mqttMessage.getPayload(), StandardCharsets.UTF_8));
                    PahoSource.this.doReceiveMessage(msg, false);
                }

                public void deliveryComplete(IMqttDeliveryToken token) {
                    System.out.println("deliveryComplete---------" + token.isComplete());
                }
            });
            MqttConnectOptions connOpts = new MqttConnectOptions();
            if (this.username != null && this.password != null) {
                connOpts.setUserName(this.username);
                connOpts.setPassword(this.password.toCharArray());
            }
            if (this.cleanSession == null) {
                connOpts.setCleanSession(true);
            } else {
                connOpts.setCleanSession(this.cleanSession.booleanValue());
            }
            if (this.connectionTimeout == null) {
                connOpts.setConnectionTimeout(10);
            } else {
                connOpts.setConnectionTimeout(this.connectionTimeout.intValue());
            }
            if (this.aliveInterval == null) {
                connOpts.setKeepAliveInterval(60);
            } else {
                connOpts.setKeepAliveInterval(this.aliveInterval.intValue());
            }
            if (this.automaticReconnect == null) {
                connOpts.setAutomaticReconnect(true);
            } else {
                connOpts.setAutomaticReconnect(this.automaticReconnect.booleanValue());
            }
            System.out.println("Connecting to broker: " + this.url);
            this.client.connect(connOpts);
            System.out.println("Connected");
            this.client.subscribe(this.topic);
            return true;
        }
        catch (MqttException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void destroy() {
        super.destroy();
        try {
            if (this.client != null) {
                this.client.disconnect();
                this.client.close();
            }
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public boolean supportRemoveSplitFind() {
        return false;
    }

    protected boolean isNotDataSplit(String queueId) {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(Boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getAliveInterval() {
        return this.aliveInterval;
    }

    public void setAliveInterval(Integer aliveInterval) {
        this.aliveInterval = aliveInterval;
    }

    public Boolean getAutomaticReconnect() {
        return this.automaticReconnect;
    }

    public void setAutomaticReconnect(Boolean automaticReconnect) {
        this.automaticReconnect = automaticReconnect;
    }
}

