/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.streams.mqtt;

import com.alibaba.fastjson.JSONObject;
import java.util.Properties;
import org.apache.rocketmq.streams.common.channel.builder.AbstractSupportShuffleChannelBuilder;
import org.apache.rocketmq.streams.common.channel.sink.ISink;
import org.apache.rocketmq.streams.common.channel.source.ISource;
import org.apache.rocketmq.streams.common.metadata.MetaData;
import org.apache.rocketmq.streams.common.model.ServiceName;
import org.apache.rocketmq.streams.common.utils.ConfigurableUtil;
import org.apache.rocketmq.streams.mqtt.sink.PahoSink;
import org.apache.rocketmq.streams.mqtt.source.PahoSource;

@ServiceName(value="mqtt", aliasName="MqttSource")
public class MqttChannelBuilder
extends AbstractSupportShuffleChannelBuilder {
    public static final String TYPE = "mqtt";

    public ISource createSource(String namespace, String name, Properties properties, MetaData metaData) {
        return (ISource)ConfigurableUtil.create((String)PahoSource.class.getName(), (String)namespace, (String)name, (JSONObject)this.createFormatProperty(properties), null);
    }

    public String getType() {
        return TYPE;
    }

    public ISink createSink(String namespace, String name, Properties properties, MetaData metaData) {
        return (ISink)ConfigurableUtil.create((String)PahoSink.class.getName(), (String)namespace, (String)name, (JSONObject)this.createFormatProperty(properties), null);
    }

    public ISink createBySource(ISource pipelineSource) {
        PahoSource source = (PahoSource)pipelineSource;
        if (source.getUsername() != null && source.getPassword() != null) {
            return new PahoSink(source.getUrl(), source.getClientId(), source.getTopic(), source.getUsername(), source.getPassword());
        }
        return new PahoSink(source.getUrl(), source.getClientId(), source.getTopic());
    }
}

