/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.java8common;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import net.javacrumbs.futureconverter.common.internal.ValueSourceFuture;

public class Java8FutureUtils {
    public static <T> CompletableFuture<T> createCompletableFuture(ValueSource<T> valueSource) {
        if (valueSource instanceof CompletableFuturebackedValueSource) {
            return ((CompletableFuturebackedValueSource)valueSource).getWrappedFuture();
        }
        return new ValueSourcebackedCompletableFuture(valueSource);
    }

    public static <T> ValueSourceFuture<T> createValueSourceFuture(CompletableFuture<T> completableFuture) {
        if (completableFuture instanceof ValueSourcebackedCompletableFuture && ((ValueSourcebackedCompletableFuture)completableFuture).getValueSource() instanceof ValueSourceFuture) {
            return (ValueSourceFuture)((ValueSourcebackedCompletableFuture)completableFuture).getValueSource();
        }
        return new CompletableFuturebackedValueSource(completableFuture);
    }

    public static <T> ValueSource<T> createValueSource(CompletableFuture<T> completableFuture) {
        if (completableFuture instanceof ValueSourcebackedCompletableFuture) {
            return ((ValueSourcebackedCompletableFuture)completableFuture).getValueSource();
        }
        return new CompletableFuturebackedValueSource(completableFuture);
    }

    private static final class CompletableFuturebackedValueSource<T>
    extends ValueSourceFuture<T> {
        private CompletableFuturebackedValueSource(CompletableFuture<T> completableFuture) {
            super(completableFuture);
        }

        @Override
        public void addCallbacks(Consumer<T> successCallback, Consumer<Throwable> failureCallback) {
            ((CompletableFuture)this.getWrappedFuture()).whenComplete((v, t) -> {
                if (t == null) {
                    successCallback.accept(v);
                } else {
                    failureCallback.accept((Throwable)t);
                }
            });
        }

        @Override
        protected CompletableFuture<T> getWrappedFuture() {
            return (CompletableFuture)super.getWrappedFuture();
        }
    }

    private static final class ValueSourcebackedCompletableFuture<T>
    extends CompletableFuture<T> {
        private final ValueSource<T> valueSource;

        private ValueSourcebackedCompletableFuture(ValueSource<T> valueSource) {
            this.valueSource = valueSource;
            valueSource.addCallbacks(this::complete, this::completeExceptionally);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.isDone()) {
                return false;
            }
            boolean result = this.valueSource.cancel(mayInterruptIfRunning);
            super.cancel(mayInterruptIfRunning);
            return result;
        }

        private ValueSource<T> getValueSource() {
            return this.valueSource;
        }
    }
}

