/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.reef.util.Optional;
import org.apache.reef.util.cache.CurrentTime;

final class WrappedValue<V> {
    private final Callable<V> valueFetcher;
    private final CurrentTime currentTime;
    private Optional<V> value;
    private Optional<Long> writeTime;

    public WrappedValue(Callable<V> valueFetcher, CurrentTime currentTime) {
        this.valueFetcher = valueFetcher;
        this.currentTime = currentTime;
        this.value = Optional.empty();
        this.writeTime = Optional.empty();
    }

    public Optional<Long> getWriteTime() {
        return this.writeTime;
    }

    public Optional<V> getValue() {
        return this.value;
    }

    public synchronized V loadAndGet() throws ExecutionException {
        try {
            this.value = Optional.ofNullable(this.valueFetcher.call());
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        finally {
            this.writeTime = Optional.of(this.currentTime.now());
            this.notifyAll();
        }
        if (!this.value.isPresent()) {
            throw new ExecutionException("valueFetcher returned null", new NullPointerException());
        }
        return this.value.get();
    }

    public synchronized V waitAndGet() {
        while (!this.value.isPresent()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.value.get();
    }
}

