/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.reef.util.Optional;
import org.apache.reef.util.cache.Cache;
import org.apache.reef.util.cache.CurrentTime;
import org.apache.reef.util.cache.WrappedValue;

public final class CacheImpl<K, V>
implements Cache<K, V> {
    private final ConcurrentMap<K, WrappedValue<V>> internalMap = new ConcurrentHashMap<K, WrappedValue<V>>();
    private final CurrentTime currentTime;
    private final long timeoutMillis;
    private final long expireCheckInterval;
    private final AtomicBoolean expireInProgress;
    private long expireCheckedTime;

    @Inject
    public CacheImpl(CurrentTime currentTime, long timeoutMillis) {
        this.currentTime = currentTime;
        this.timeoutMillis = timeoutMillis;
        this.expireCheckInterval = timeoutMillis / 2L;
        this.expireInProgress = new AtomicBoolean(false);
        this.expireCheckedTime = currentTime.now();
    }

    @Override
    public V get(K key, Callable<V> valueFetcher) throws ExecutionException {
        this.expireEntries();
        WrappedValue<V> newWrappedValue = new WrappedValue<V>(valueFetcher, this.currentTime);
        WrappedValue<V> existingWrappedValue = this.internalMap.putIfAbsent(key, newWrappedValue);
        if (existingWrappedValue == null) {
            return newWrappedValue.loadAndGet();
        }
        Optional<V> existingValue = existingWrappedValue.getValue();
        if (existingValue.isPresent()) {
            return existingValue.get();
        }
        return existingWrappedValue.waitAndGet();
    }

    private void expireEntries() {
        if (this.expireInProgress.compareAndSet(false, true)) {
            long now = this.currentTime.now();
            if (this.expireCheckedTime + this.expireCheckInterval < now) {
                this.expireEntriesAtTime(now);
                this.expireCheckedTime = now;
            }
            this.expireInProgress.compareAndSet(true, false);
        }
    }

    private void expireEntriesAtTime(long now) {
        for (Object key : this.internalMap.keySet()) {
            Optional<Long> writeTime;
            WrappedValue wrappedValue = (WrappedValue)this.internalMap.get(key);
            if (wrappedValue == null || !(writeTime = wrappedValue.getWriteTime()).isPresent() || writeTime.get() + this.timeoutMillis >= now) continue;
            this.invalidate(key);
        }
    }

    @Override
    public void invalidate(K key) {
        this.internalMap.remove(key);
    }
}

