/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.util;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@Immutable
@ThreadSafe
public final class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final T value;
    private final String valueStr;
    private final int valueHash;

    private Optional(T value) {
        this.value = value;
        this.valueStr = "Optional:{" + value + '}';
        this.valueHash = value.hashCode();
    }

    private Optional() {
        this.value = null;
        this.valueStr = "OptionalvNothing";
        this.valueHash = 0;
    }

    public static <T> Optional<T> of(T value) throws NullPointerException {
        if (null == value) {
            throw new NullPointerException("Passed a null value. Use ofNullable() instead");
        }
        return new Optional<T>(value);
    }

    public static <T> Optional<T> empty() {
        return new Optional<T>();
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (null == value) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public T get() {
        return this.value;
    }

    public T orElse(T other) {
        if (this.isPresent()) {
            return this.get();
        }
        return other;
    }

    public boolean isPresent() {
        return null != this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Optional that = (Optional)obj;
        return this.value == that.value || this.value != null && this.value.equals(that.value);
    }

    public int hashCode() {
        return this.valueHash;
    }

    public String toString() {
        return this.valueStr;
    }
}

