/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.yarn.failure;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.DriverLauncher;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.runtime.local.client.LocalRuntimeConfiguration;
import org.apache.reef.runtime.yarn.client.YarnClientConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.ConfigurationBuilder;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.JavaConfigurationBuilder;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.annotations.NamedParameter;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.CommandLine;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.yarn.failure.FailureDriver;
import org.apache.reef.util.EnvironmentUtils;

public final class FailureREEF {
    public static final int MAX_NUMBER_OF_EVALUATORS = 16;
    private static final Logger LOG = Logger.getLogger(FailureREEF.class.getName());

    private static Configuration parseCommandLine(String[] aArgs) {
        JavaConfigurationBuilder cb = Tang.Factory.getTang().newConfigurationBuilder();
        try {
            new CommandLine((ConfigurationBuilder)cb).registerShortNameOfClass(Local.class).registerShortNameOfClass(TimeOut.class).processCommandLine(aArgs, new Class[0]);
            return cb.build();
        }
        catch (IOException | BindException ex) {
            String msg = "Unable to parse command line";
            LOG.log(Level.SEVERE, "Unable to parse command line", ex);
            throw new RuntimeException("Unable to parse command line", ex);
        }
    }

    private static Configuration getRunTimeConfiguration(boolean isLocal) throws BindException {
        Configuration runtimeConfiguration;
        if (isLocal) {
            LOG.log(Level.INFO, "Running Failure demo on the local runtime");
            runtimeConfiguration = LocalRuntimeConfiguration.CONF.set((Param)LocalRuntimeConfiguration.MAX_NUMBER_OF_EVALUATORS, (Number)16).build();
        } else {
            LOG.log(Level.INFO, "Running Failure demo on YARN");
            runtimeConfiguration = YarnClientConfiguration.CONF.build();
        }
        return runtimeConfiguration;
    }

    public static LauncherStatus runFailureReef(Configuration runtimeConfig, int timeout) throws InjectionException {
        Configuration driverConf = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(FailureDriver.class)).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "FailureREEF").set((Impl)DriverConfiguration.ON_DRIVER_STARTED, FailureDriver.StartHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, FailureDriver.EvaluatorAllocatedHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_FAILED, FailureDriver.EvaluatorFailedHandler.class).build();
        LauncherStatus state = DriverLauncher.getLauncher((Configuration)runtimeConfig).run(driverConf, (long)timeout);
        LOG.log(Level.INFO, "REEF job completed: {0}", state);
        return state;
    }

    public static void main(String[] args) throws InjectionException {
        Configuration commandLineConf = FailureREEF.parseCommandLine(args);
        Injector injector = Tang.Factory.getTang().newInjector(commandLineConf);
        boolean isLocal = (Boolean)injector.getNamedInstance(Local.class);
        int jobTimeout = (Integer)injector.getNamedInstance(TimeOut.class) * 60 * 1000;
        FailureREEF.runFailureReef(FailureREEF.getRunTimeConfiguration(isLocal), jobTimeout);
    }

    private FailureREEF() {
    }

    @NamedParameter(doc="Number of minutes before timeout", short_name="timeout", default_value="2")
    public static final class TimeOut
    implements Name<Integer> {
    }

    @NamedParameter(doc="Whether or not to run on the local runtime", short_name="local", default_value="true")
    public static final class Local
    implements Name<Boolean> {
    }
}

