/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.yarn.failure;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.evaluator.FailedEvaluator;
import org.apache.reef.poison.PoisonedConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

@Unit
public class FailureDriver {
    private static final int NUM_EVALUATORS = 40;
    private static final int NUM_FAILURES = 10;
    private final AtomicInteger toSubmit = new AtomicInteger(10);
    private static final Logger LOG = Logger.getLogger(FailureDriver.class.getName());
    private final EvaluatorRequestor requestor;

    @Inject
    public FailureDriver(EvaluatorRequestor requestor) {
        this.requestor = requestor;
        LOG.info("Driver instantiated");
    }

    final class EvaluatorFailedHandler
    implements EventHandler<FailedEvaluator> {
        EvaluatorFailedHandler() {
        }

        public void onNext(FailedEvaluator failedEvaluator) {
            LOG.log(Level.FINE, "Got failed evaluator: {0} - re-request", failedEvaluator.getId());
            FailureDriver.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(64).setNumberOfCores(1).build());
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator allocatedEvaluator) {
            String evalId = allocatedEvaluator.getId();
            LOG.log(Level.FINE, "Got allocated evaluator: {0}", evalId);
            if (FailureDriver.this.toSubmit.getAndDecrement() > 0) {
                LOG.log(Level.FINE, "Submitting poisoned context. {0} to go.", FailureDriver.this.toSubmit);
                allocatedEvaluator.submitContext(Tang.Factory.getTang().newConfigurationBuilder(new Configuration[]{ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "Poisoned Context: " + evalId).build(), PoisonedConfiguration.CONTEXT_CONF.set((Param)PoisonedConfiguration.CRASH_PROBABILITY, "1").set((Param)PoisonedConfiguration.CRASH_TIMEOUT, "1").build()}).build());
            } else {
                LOG.log(Level.FINE, "Closing evaluator {0}", evalId);
                allocatedEvaluator.close();
            }
        }
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime startTime) {
            LOG.log(Level.FINE, "Request {0} Evaluators.", 40);
            FailureDriver.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(40).setMemory(64).setNumberOfCores(1).build());
        }
    }
}

