/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.statepassing;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.client.JobMessageObserver;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.context.ServiceConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.task.CompletedTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.JavaConfigurationBuilder;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.statepassing.Counter;
import org.apache.reef.tests.statepassing.StatePassingTask;
import org.apache.reef.wake.EventHandler;

@Unit
public class StatePassingDriver {
    private static final Logger LOG = Logger.getLogger(StatePassingDriver.class.getName());
    private static final int PASSES = 2;
    private final JobMessageObserver client;
    private int pass = 0;

    @Inject
    public StatePassingDriver(JobMessageObserver client) {
        this.client = client;
    }

    private static boolean allEqual(byte value, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == value) continue;
            return false;
        }
        return true;
    }

    private void nextPass(ActiveContext activeContext) {
        try {
            activeContext.submitTask(TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, "StatePassing-" + this.pass).set((Impl)TaskConfiguration.TASK, StatePassingTask.class).build());
            ++this.pass;
        }
        catch (BindException e) {
            throw new RuntimeException(e);
        }
    }

    final class TaskCompletedHandler
    implements EventHandler<CompletedTask> {
        TaskCompletedHandler() {
        }

        public void onNext(CompletedTask completed) {
            LOG.log(Level.INFO, "Received a completed task: " + completed);
            byte[] message = completed.get();
            if (message.length != StatePassingDriver.this.pass) {
                String msg = "Expected message of length " + StatePassingDriver.this.pass + ", but got message of length " + message.length;
                RuntimeException ex = new RuntimeException(msg);
                throw ex;
            }
            if (!StatePassingDriver.allEqual((byte)1, message)) {
                RuntimeException ex = new RuntimeException("Did not get the right message");
                throw ex;
            }
            if (StatePassingDriver.this.pass < 2) {
                LOG.log(Level.INFO, "Submitting the next Task");
                StatePassingDriver.this.nextPass(completed.getActiveContext());
            } else {
                LOG.log(Level.INFO, "Done");
                completed.getActiveContext().close();
            }
        }
    }

    final class ContextActiveHandler
    implements EventHandler<ActiveContext> {
        ContextActiveHandler() {
        }

        public void onNext(ActiveContext activeContext) {
            StatePassingDriver.this.nextPass(activeContext);
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator eb) {
            JavaConfigurationBuilder b = Tang.Factory.getTang().newConfigurationBuilder();
            try {
                Configuration contextConfiguration = ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "StatePassingContext").build();
                Configuration serviceConfiguration = ServiceConfiguration.CONF.set((Param)ServiceConfiguration.SERVICES, Counter.class).build();
                eb.submitContextAndService(contextConfiguration, serviceConfiguration);
            }
            catch (BindException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

