/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.messaging.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.task.Task;
import org.apache.reef.task.TaskMessage;
import org.apache.reef.task.TaskMessageSource;
import org.apache.reef.task.events.DriverMessage;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.impl.ObjectSerializableCodec;

@Unit
public final class TaskMessagingTask
implements Task,
TaskMessageSource {
    private static final Logger LOG = Logger.getLogger(TaskMessagingTask.class.getName());
    private static final ObjectSerializableCodec<String> CODEC = new ObjectSerializableCodec();
    private static final TaskMessage INIT_MESSAGE = TaskMessage.from((String)"", (byte[])CODEC.encode((Object)"MESSAGE::INIT"));
    private transient boolean isRunning = true;
    private transient Optional<TaskMessage> message = Optional.empty();

    @Inject
    public TaskMessagingTask() {
        LOG.info("TaskMsg created.");
    }

    public synchronized byte[] call(byte[] memento) {
        LOG.info("TaskMsg.call() invoked. Waiting for the message.");
        while (this.isRunning) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.WARNING, "wait() interrupted.", ex);
            }
        }
        return ((TaskMessage)this.message.orElse((Object)INIT_MESSAGE)).get();
    }

    public synchronized Optional<TaskMessage> getMessage() {
        LOG.log(Level.INFO, "TaskMsg.getMessage() invoked: {0}", CODEC.decode(((TaskMessage)this.message.orElse((Object)INIT_MESSAGE)).get()));
        if (this.message.isPresent()) {
            this.isRunning = false;
            this.notify();
        }
        return this.message;
    }

    public class DriverMessageHandler
    implements EventHandler<DriverMessage> {
        public void onNext(DriverMessage driverMessage) {
            byte[] driverMsg = (byte[])driverMessage.get().get();
            LOG.log(Level.INFO, "TaskMsg.send() invoked: {0}", CODEC.decode(driverMsg));
            TaskMessagingTask.this.message = Optional.of((Object)TaskMessage.from((String)this.toString(), (byte[])driverMsg));
        }
    }
}

