/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.messaging.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.client.JobMessageObserver;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.Clock;
import org.apache.reef.wake.time.event.Alarm;
import org.apache.reef.wake.time.event.StartTime;

@Unit
final class DriverMessagingDriver {
    private static final Logger LOG = Logger.getLogger(DriverMessagingDriver.class.getName());
    private static final int DELAY = 2000;
    private final Clock clock;
    private final JobMessageObserver client;

    @Inject
    DriverMessagingDriver(Clock clock, JobMessageObserver client) {
        this.clock = clock;
        this.client = client;
    }

    final class AllocatedEvaluatorHandler
    implements EventHandler<AllocatedEvaluator> {
        AllocatedEvaluatorHandler() {
        }

        public void onNext(AllocatedEvaluator eval) {
            throw new RuntimeException("This should never be called");
        }
    }

    final class ClientMessageHandler
    implements EventHandler<byte[]> {
        ClientMessageHandler() {
        }

        public void onNext(byte[] message) {
            LOG.log(Level.INFO, "Message received: {0}", String.valueOf(message));
            DriverMessagingDriver.this.client.sendMessageToClient(message);
            DriverMessagingDriver.this.clock.scheduleAlarm(2000, (EventHandler)new EventHandler<Alarm>(){

                public void onNext(Alarm alarm) {
                }
            });
        }
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime startTime) {
            DriverMessagingDriver.this.clock.scheduleAlarm(2000, (EventHandler)new EventHandler<Alarm>(){

                public void onNext(Alarm alarm) {
                }
            });
        }
    }
}

