/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.messaging.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.client.ClientConfiguration;
import org.apache.reef.client.CompletedJob;
import org.apache.reef.client.DriverConfiguration;
import org.apache.reef.client.FailedJob;
import org.apache.reef.client.FailedRuntime;
import org.apache.reef.client.JobMessage;
import org.apache.reef.client.LauncherStatus;
import org.apache.reef.client.REEF;
import org.apache.reef.client.RunningJob;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.messaging.driver.DriverMessagingDriver;
import org.apache.reef.util.EnvironmentUtils;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;

@Unit
public final class DriverMessaging {
    private static final Logger LOG = Logger.getLogger(DriverMessaging.class.getName());
    private final REEF reef;
    private String lastMessage = null;
    private Optional<RunningJob> theJob = Optional.empty();
    private LauncherStatus status = LauncherStatus.INIT;

    @Inject
    private DriverMessaging(REEF reef) {
        this.reef = reef;
    }

    public static LauncherStatus run(Configuration runtimeConfiguration, int launcherTimeout) throws BindException, InjectionException {
        Configuration clientConfiguration = ClientConfiguration.CONF.set((Impl)ClientConfiguration.ON_JOB_RUNNING, RunningJobHandler.class).set((Impl)ClientConfiguration.ON_JOB_MESSAGE, JobMessageHandler.class).set((Impl)ClientConfiguration.ON_JOB_COMPLETED, CompletedJobHandler.class).set((Impl)ClientConfiguration.ON_JOB_FAILED, FailedJobHandler.class).set((Impl)ClientConfiguration.ON_RUNTIME_ERROR, RuntimeErrorHandler.class).build();
        return ((DriverMessaging)Tang.Factory.getTang().newInjector(new Configuration[]{runtimeConfiguration, clientConfiguration}).getInstance(DriverMessaging.class)).run(launcherTimeout, 1000L);
    }

    public synchronized void close() {
        if (this.status.isRunning()) {
            this.status = LauncherStatus.FORCE_CLOSED;
        }
        if (this.theJob.isPresent()) {
            ((RunningJob)this.theJob.get()).close();
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LauncherStatus run(long jobTimeout, long statusTimeout) {
        long startTime = System.currentTimeMillis();
        LOG.log(Level.INFO, "Submitting REEF Job");
        Configuration driverConfig = DriverConfiguration.CONF.set((Param)DriverConfiguration.GLOBAL_LIBRARIES, EnvironmentUtils.getClassLocation(this.getClass())).set((Param)DriverConfiguration.DRIVER_IDENTIFIER, "DriverMessagingTest").set((Impl)DriverConfiguration.ON_DRIVER_STARTED, DriverMessagingDriver.StartHandler.class).set((Impl)DriverConfiguration.ON_EVALUATOR_ALLOCATED, DriverMessagingDriver.AllocatedEvaluatorHandler.class).set((Impl)DriverConfiguration.ON_CLIENT_MESSAGE, DriverMessagingDriver.ClientMessageHandler.class).build();
        this.reef.submit(driverConfig);
        DriverMessaging driverMessaging = this;
        synchronized (driverMessaging) {
            while (!this.status.isDone()) {
                LOG.log(Level.INFO, "Waiting for REEF job to finish.");
                try {
                    this.wait(statusTimeout);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINER, "Waiting for REEF job interrupted.", ex);
                }
                if (System.currentTimeMillis() - startTime < jobTimeout) continue;
                LOG.log(Level.INFO, "Waiting for REEF job timed out after {0} sec.", (System.currentTimeMillis() - startTime) / 1000L);
                break;
            }
        }
        this.reef.close();
        return this.status;
    }

    final class RuntimeErrorHandler
    implements EventHandler<FailedRuntime> {
        RuntimeErrorHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(FailedRuntime error) {
            LOG.log(Level.SEVERE, "Received a runtime error: " + error, (Throwable)error.getReason().orElse(null));
            DriverMessaging driverMessaging = DriverMessaging.this;
            synchronized (driverMessaging) {
                DriverMessaging.this.status = LauncherStatus.failed((Optional)error.getReason());
                DriverMessaging.this.notify();
            }
        }
    }

    final class FailedJobHandler
    implements EventHandler<FailedJob> {
        FailedJobHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(FailedJob job) {
            LOG.log(Level.SEVERE, "Received an error for job " + job.getId(), (Throwable)job.getReason().orElse(null));
            DriverMessaging driverMessaging = DriverMessaging.this;
            synchronized (driverMessaging) {
                DriverMessaging.this.status = LauncherStatus.failed((Optional)job.getReason());
                DriverMessaging.this.notify();
            }
        }
    }

    final class CompletedJobHandler
    implements EventHandler<CompletedJob> {
        CompletedJobHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(CompletedJob job) {
            LOG.log(Level.INFO, "Job Completed: {0}", job);
            DriverMessaging driverMessaging = DriverMessaging.this;
            synchronized (driverMessaging) {
                DriverMessaging.this.status = LauncherStatus.COMPLETED;
                DriverMessaging.this.notify();
            }
        }
    }

    final class RunningJobHandler
    implements EventHandler<RunningJob> {
        RunningJobHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(RunningJob job) {
            LOG.log(Level.INFO, "The Job {0} is running", job.getId());
            DriverMessaging driverMessaging = DriverMessaging.this;
            synchronized (driverMessaging) {
                DriverMessaging.this.status = LauncherStatus.RUNNING;
                DriverMessaging.this.theJob = Optional.of((Object)job);
                DriverMessaging.this.lastMessage = "Hello, REEF!";
                ((RunningJob)DriverMessaging.this.theJob.get()).send(DriverMessaging.this.lastMessage.getBytes());
            }
        }
    }

    final class JobMessageHandler
    implements EventHandler<JobMessage> {
        JobMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(JobMessage message) {
            String msg = new String(message.get());
            DriverMessaging driverMessaging = DriverMessaging.this;
            synchronized (driverMessaging) {
                if (!msg.equals(DriverMessaging.this.lastMessage)) {
                    LOG.log(Level.SEVERE, "Expected {0} but got {1}", new Object[]{DriverMessaging.this.lastMessage, msg});
                    DriverMessaging.this.status = LauncherStatus.FAILED;
                    DriverMessaging.this.notify();
                }
            }
        }
    }
}

