/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.library.driver;

import javax.inject.Inject;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.task.FailedTask;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.tests.library.exceptions.ExpectedTaskException;
import org.apache.reef.util.Exceptions;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;

public final class ExpectedTaskFailureHandler
implements EventHandler<FailedTask> {
    @Inject
    public ExpectedTaskFailureHandler() {
    }

    public void onNext(FailedTask failedTask) {
        Optional reasonOptional = failedTask.getReason();
        if (!reasonOptional.isPresent()) {
            throw new DriverSideFailure("Received a FailedTask, but it did not contain an exception.");
        }
        if (!(Exceptions.getUltimateCause((Throwable)((Throwable)reasonOptional.get())) instanceof ExpectedTaskException)) {
            throw new DriverSideFailure("Received a FailedTask, but the ExpectedTaskException isn't the ultimate cause.", (Throwable)reasonOptional.get());
        }
        ((ActiveContext)failedTask.getActiveContext().get()).close();
    }
}

