/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.task.Task;
import org.apache.reef.task.events.SuspendEvent;
import org.apache.reef.tests.library.exceptions.SimulatedTaskFailure;
import org.apache.reef.wake.EventHandler;

public final class FailTaskSuspend
implements Task,
EventHandler<SuspendEvent> {
    private static final Logger LOG = Logger.getLogger(FailTaskSuspend.class.getName());
    private transient boolean isRunning = true;

    @Inject
    public FailTaskSuspend() {
        LOG.info("FailTaskSuspend created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] call(byte[] memento) {
        FailTaskSuspend failTaskSuspend = this;
        synchronized (failTaskSuspend) {
            LOG.info("FailTaskSuspend.call() invoked. Waiting for suspend request.");
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.WARNING, "wait() interrupted.", ex);
                }
            }
        }
        return new byte[0];
    }

    public void onNext(SuspendEvent event) throws SimulatedTaskFailure {
        SimulatedTaskFailure ex = new SimulatedTaskFailure("FailTaskSuspend.send() invoked.");
        LOG.log(Level.FINE, "FailTaskSuspend.send() invoked: {0}", ex);
        throw ex;
    }
}

