/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.task.Task;
import org.apache.reef.task.events.CloseEvent;
import org.apache.reef.task.events.TaskStop;
import org.apache.reef.tests.library.exceptions.SimulatedTaskFailure;
import org.apache.reef.wake.EventHandler;

@Unit
public final class FailTaskStop
implements Task,
EventHandler<TaskStop> {
    private static final Logger LOG = Logger.getLogger(FailTaskStop.class.getName());
    private transient boolean isRunning = true;

    @Inject
    public FailTaskStop() {
        LOG.fine("FailTaskStop created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] call(byte[] memento) {
        FailTaskStop failTaskStop = this;
        synchronized (failTaskStop) {
            LOG.fine("FailTaskStop.call() invoked. Waiting for the message.");
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.WARNING, "wait() interrupted.", ex);
                }
            }
        }
        return null;
    }

    public void onNext(TaskStop event) throws SimulatedTaskFailure {
        SimulatedTaskFailure ex = new SimulatedTaskFailure("FailTaskStop.send() invoked.");
        LOG.log(Level.FINE, "FailTaskStop.onNext() invoked. Raise exception: {0}", ex.toString());
        throw ex;
    }

    public final class CloseEventHandler
    implements EventHandler<CloseEvent> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(CloseEvent event) {
            LOG.log(Level.FINEST, "FailTaskStop.CloseEventHandler.onNext() invoked: {0}", event);
            FailTaskStop failTaskStop = FailTaskStop.this;
            synchronized (failTaskStop) {
                FailTaskStop.this.isRunning = false;
                FailTaskStop.this.notify();
            }
        }
    }
}

