/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.task.Task;
import org.apache.reef.task.events.CloseEvent;
import org.apache.reef.tests.library.exceptions.SimulatedTaskFailure;
import org.apache.reef.wake.EventHandler;

public final class FailTaskClose
implements Task,
EventHandler<CloseEvent> {
    private static final Logger LOG = Logger.getLogger(FailTaskClose.class.getName());
    private transient boolean isRunning = true;

    @Inject
    public FailTaskClose() {
        LOG.fine("FailTaskClose created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] call(byte[] memento) {
        FailTaskClose failTaskClose = this;
        synchronized (failTaskClose) {
            LOG.fine("FailTaskClose.call() invoked. Waiting for the message.");
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.WARNING, "wait() interrupted.", ex);
                }
            }
        }
        return new byte[0];
    }

    public void onNext(CloseEvent event) throws SimulatedTaskFailure {
        SimulatedTaskFailure ex = new SimulatedTaskFailure("FailTaskClose.send() invoked.");
        LOG.log(Level.FINE, "FailTaskClose.onNext() invoked. Raise exception: {0}", ex.toString());
        throw ex;
    }
}

