/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.annotations.NamedParameter;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.ConfigurationModule;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.fail.task.FailTask;
import org.apache.reef.tests.fail.task.FailTaskCall;
import org.apache.reef.tests.fail.task.FailTaskClose;
import org.apache.reef.tests.fail.task.FailTaskMsg;
import org.apache.reef.tests.fail.task.FailTaskStart;
import org.apache.reef.tests.fail.task.FailTaskStop;
import org.apache.reef.tests.fail.task.FailTaskSuspend;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

@Unit
public final class Driver {
    private static final Logger LOG = Logger.getLogger(Driver.class.getName());
    private final transient String failTaskName;
    private final transient EvaluatorRequestor requestor;
    private transient String taskId;

    @Inject
    public Driver(@Parameter(value=FailTaskName.class) String failTaskName, EvaluatorRequestor requestor) {
        this.failTaskName = failTaskName;
        this.requestor = requestor;
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime time) {
            LOG.log(Level.INFO, "StartTime: {0}", time);
            Driver.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(128).setNumberOfCores(1).build());
        }
    }

    final class ActiveContextHandler
    implements EventHandler<ActiveContext> {
        ActiveContextHandler() {
        }

        public void onNext(ActiveContext context) throws DriverSideFailure {
            throw new DriverSideFailure("Unexpected ActiveContext message: " + context.getId());
        }
    }

    final class RunningTaskHandler
    implements EventHandler<RunningTask> {
        RunningTaskHandler() {
        }

        public void onNext(RunningTask task) {
            LOG.log(Level.INFO, "TaskRuntime: {0} expect {1}", new Object[]{task.getId(), Driver.this.taskId});
            if (!Driver.this.taskId.equals(task.getId())) {
                throw new DriverSideFailure("Task ID " + task.getId() + " not equal expected ID " + Driver.this.taskId);
            }
            switch (Driver.this.failTaskName) {
                case "FailTaskMsg": {
                    LOG.log(Level.INFO, "TaskRuntime: Send message: {0}", task);
                    task.send(new byte[0]);
                    break;
                }
                case "FailTaskSuspend": {
                    LOG.log(Level.INFO, "TaskRuntime: Suspend: {0}", task);
                    task.suspend();
                    break;
                }
                case "FailTaskStop": 
                case "FailTaskClose": {
                    LOG.log(Level.INFO, "TaskRuntime: Stop/Close: {0}", task);
                    task.close();
                    break;
                }
            }
        }
    }

    final class AllocatedEvaluatorHandler
    implements EventHandler<AllocatedEvaluator> {
        AllocatedEvaluatorHandler() {
        }

        public void onNext(AllocatedEvaluator eval) {
            try {
                Driver.this.taskId = Driver.this.failTaskName + "_" + eval.getId();
                LOG.log(Level.INFO, "Submit task: {0}", Driver.this.taskId);
                Configuration contextConfig = ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, Driver.this.taskId).build();
                ConfigurationModule taskConfig = TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, Driver.this.taskId);
                switch (Driver.this.failTaskName) {
                    case "FailTask": {
                        taskConfig = taskConfig.set((Impl)TaskConfiguration.TASK, FailTask.class);
                        break;
                    }
                    case "FailTaskCall": {
                        taskConfig = taskConfig.set((Impl)TaskConfiguration.TASK, FailTaskCall.class);
                        break;
                    }
                    case "FailTaskMsg": {
                        taskConfig = taskConfig.set((Impl)TaskConfiguration.TASK, FailTaskMsg.class).set((Impl)TaskConfiguration.ON_MESSAGE, FailTaskMsg.class);
                        break;
                    }
                    case "FailTaskSuspend": {
                        taskConfig = taskConfig.set((Impl)TaskConfiguration.TASK, FailTaskSuspend.class).set((Impl)TaskConfiguration.ON_SUSPEND, FailTaskSuspend.class);
                        break;
                    }
                    case "FailTaskStart": {
                        taskConfig = taskConfig.set((Impl)TaskConfiguration.TASK, FailTaskStart.class).set((Impl)TaskConfiguration.ON_TASK_STARTED, FailTaskStart.class);
                        break;
                    }
                    case "FailTaskStop": {
                        taskConfig = taskConfig.set((Impl)TaskConfiguration.TASK, FailTaskStop.class).set((Impl)TaskConfiguration.ON_TASK_STOP, FailTaskStop.class).set((Impl)TaskConfiguration.ON_CLOSE, FailTaskStop.CloseEventHandler.class);
                        break;
                    }
                    case "FailTaskClose": {
                        taskConfig = taskConfig.set((Impl)TaskConfiguration.TASK, FailTaskClose.class).set((Impl)TaskConfiguration.ON_CLOSE, FailTaskClose.class);
                        break;
                    }
                }
                eval.submitContextAndTask(contextConfig, taskConfig.build());
            }
            catch (BindException ex) {
                LOG.log(Level.WARNING, "Configuration error", ex);
                throw new DriverSideFailure("Configuration error", ex);
            }
        }
    }

    @NamedParameter(doc="Full name of the (failing) task class", short_name="task")
    public static final class FailTaskName
    implements Name<String> {
    }
}

