/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.task.Task;
import org.apache.reef.task.TaskMessage;
import org.apache.reef.task.TaskMessageSource;
import org.apache.reef.task.events.CloseEvent;
import org.apache.reef.task.events.DriverMessage;
import org.apache.reef.task.events.SuspendEvent;
import org.apache.reef.task.events.TaskStop;
import org.apache.reef.util.Optional;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.impl.ObjectSerializableCodec;

@Unit
public final class NoopTask
implements Task,
TaskMessageSource {
    private static final Logger LOG = Logger.getLogger(NoopTask.class.getName());
    private static final ObjectSerializableCodec<String> CODEC = new ObjectSerializableCodec();
    private static final TaskMessage INIT_MESSAGE = TaskMessage.from((String)"", (byte[])CODEC.encode((Object)"MESSAGE::INIT"));
    private transient boolean isRunning = true;
    private transient Optional<TaskMessage> message = Optional.empty();

    @Inject
    public NoopTask() {
        LOG.info("NoopTask created.");
    }

    public synchronized byte[] call(byte[] memento) {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                LOG.info("NoopTask.call(): Waiting for the message.");
                this.wait();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.WARNING, "NoopTask.wait() interrupted.", ex);
            }
        }
        LOG.log(Level.INFO, "NoopTask.call(): Exiting with message {0}", CODEC.decode(((TaskMessage)this.message.orElse((Object)INIT_MESSAGE)).get()));
        return ((TaskMessage)this.message.orElse((Object)INIT_MESSAGE)).get();
    }

    public synchronized Optional<TaskMessage> getMessage() {
        LOG.log(Level.INFO, "NoopTask.getMessage() invoked: {0}", CODEC.decode(((TaskMessage)this.message.orElse((Object)INIT_MESSAGE)).get()));
        return this.message;
    }

    private synchronized void stopTask() {
        LOG.info("NoopTask.stopTask() invoked.");
        this.isRunning = false;
        this.notify();
    }

    public class DriverMessageHandler
    implements EventHandler<DriverMessage> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(DriverMessage driverMessage) {
            byte[] msg = (byte[])driverMessage.get().get();
            LOG.log(Level.INFO, "NoopTask.DriverMessageHandler.send() invoked: {0}", CODEC.decode(msg));
            NoopTask noopTask = NoopTask.this;
            synchronized (noopTask) {
                NoopTask.this.message = Optional.of((Object)TaskMessage.from((String)NoopTask.this.toString(), (byte[])msg));
            }
        }
    }

    public class TaskCloseHandler
    implements EventHandler<CloseEvent> {
        public void onNext(CloseEvent closeEvent) {
            LOG.info("NoopTask.TaskCloseHandler.send() invoked.");
            NoopTask.this.stopTask();
        }
    }

    public class TaskStopHandler
    implements EventHandler<TaskStop> {
        public void onNext(TaskStop event) {
            LOG.info("NoopTask.TaskStopHandler.send() invoked.");
            NoopTask.this.stopTask();
        }
    }

    public class TaskSuspendHandler
    implements EventHandler<SuspendEvent> {
        public void onNext(SuspendEvent suspendEvent) {
            LOG.info("NoopTask.TaskSuspendHandler.send() invoked.");
            NoopTask.this.stopTask();
        }
    }
}

