/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.driver;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.driver.task.TaskMessage;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.fail.driver.NoopTask;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.impl.ObjectSerializableCodec;
import org.apache.reef.wake.time.Clock;
import org.apache.reef.wake.time.event.Alarm;
import org.apache.reef.wake.time.event.StartTime;

@Unit
public final class FailDriverDelayedMsg {
    private static final Logger LOG = Logger.getLogger(FailDriverDelayedMsg.class.getName());
    private static final ObjectSerializableCodec<String> CODEC = new ObjectSerializableCodec();
    private static final byte[] HELLO_STR = CODEC.encode((Object)"MESSAGE::HELLO");
    private final transient EvaluatorRequestor requestor;
    private final transient Clock clock;
    private transient RunningTask task = null;

    @Inject
    public FailDriverDelayedMsg(EvaluatorRequestor requestor, Clock clock) {
        LOG.log(Level.INFO, "ENTER: FailDriverDelayedMsg.<init>");
        this.requestor = requestor;
        this.clock = clock;
    }

    public final class StartHandler
    implements EventHandler<StartTime> {
        public void onNext(StartTime time) {
            LOG.log(Level.INFO, "ENTER: FailDriverDelayedMsg.send(StartTime): {0}", time);
            FailDriverDelayedMsg.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(128).setNumberOfCores(1).build());
        }
    }

    public final class TaskMessageHandler
    implements EventHandler<TaskMessage> {
        public void onNext(TaskMessage msg) {
            LOG.log(Level.INFO, "ENTER: FailDriverDelayedMsg.send(TaskMessage): {0}", msg);
            assert (Arrays.equals(HELLO_STR, msg.get()));
            FailDriverDelayedMsg.this.task.close();
        }
    }

    public final class RunningTaskHandler
    implements EventHandler<RunningTask> {
        public void onNext(final RunningTask task) {
            FailDriverDelayedMsg.this.task = task;
            LOG.log(Level.INFO, "ENTER: FailDriverDelayedMsg.send(TaskRuntime): {0}", task);
            FailDriverDelayedMsg.this.clock.scheduleAlarm(2000, (EventHandler)new EventHandler<Alarm>(){

                public void onNext(Alarm time) {
                    LOG.log(Level.INFO, "ENTER: FailDriverDelayedMsg.send(Alarm): {0}", time);
                    task.send(HELLO_STR);
                }
            });
        }
    }

    public final class ActiveContextHandler
    implements EventHandler<ActiveContext> {
        public void onNext(ActiveContext context) {
            LOG.log(Level.INFO, "ENTER: FailDriverDelayedMsg.send(ActiveContext): {0}", context);
            try {
                context.submitTask(TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, "Task_" + context.getId()).set((Impl)TaskConfiguration.TASK, NoopTask.class).set((Impl)TaskConfiguration.ON_MESSAGE, NoopTask.DriverMessageHandler.class).set((Impl)TaskConfiguration.ON_SUSPEND, NoopTask.TaskSuspendHandler.class).set((Impl)TaskConfiguration.ON_TASK_STOP, NoopTask.TaskStopHandler.class).set((Impl)TaskConfiguration.ON_CLOSE, NoopTask.TaskCloseHandler.class).set((Impl)TaskConfiguration.ON_SEND_MESSAGE, NoopTask.class).build());
            }
            catch (BindException ex) {
                LOG.log(Level.WARNING, "Task configuration error", ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public final class AllocatedEvaluatorHandler
    implements EventHandler<AllocatedEvaluator> {
        public void onNext(AllocatedEvaluator eval) {
            LOG.log(Level.INFO, "ENTER: FailDriverDelayedMsg.send(AllocatedEvaluator): {0}", eval);
            try {
                eval.submitContext(ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "Context_" + eval.getId()).build());
            }
            catch (BindException ex) {
                LOG.log(Level.WARNING, "Context configuration error", ex);
                throw new RuntimeException(ex);
            }
        }
    }
}

