/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.driver;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.bind.DatatypeConverter;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ClosedContext;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.context.ContextMessage;
import org.apache.reef.driver.context.FailedContext;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.CompletedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.evaluator.FailedEvaluator;
import org.apache.reef.driver.task.CompletedTask;
import org.apache.reef.driver.task.FailedTask;
import org.apache.reef.driver.task.RunningTask;
import org.apache.reef.driver.task.SuspendedTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.driver.task.TaskMessage;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.annotations.NamedParameter;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.fail.driver.NoopTask;
import org.apache.reef.tests.library.exceptions.DriverSideFailure;
import org.apache.reef.tests.library.exceptions.SimulatedDriverFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.remote.impl.ObjectSerializableCodec;
import org.apache.reef.wake.time.Clock;
import org.apache.reef.wake.time.event.Alarm;
import org.apache.reef.wake.time.event.StartTime;
import org.apache.reef.wake.time.event.StopTime;

@Unit
public final class FailDriver {
    private static final Logger LOG = Logger.getLogger(FailDriver.class.getName());
    private static final ObjectSerializableCodec<String> CODEC = new ObjectSerializableCodec();
    private static final byte[] HELLO_STR = CODEC.encode((Object)"MESSAGE::HELLO");
    private static final int MSG_DELAY = 1000;
    private static final ExpectedMessage[] EVENT_SEQUENCE = new ExpectedMessage[]{new ExpectedMessage(FailDriver.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(StartTime.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(AllocatedEvaluator.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(FailedEvaluator.class, ExpectedMessage.RequiredFlag.OPTIONAL), new ExpectedMessage(ActiveContext.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(ContextMessage.class, ExpectedMessage.RequiredFlag.OPTIONAL), new ExpectedMessage(FailedContext.class, ExpectedMessage.RequiredFlag.OPTIONAL), new ExpectedMessage(RunningTask.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(Alarm.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(TaskMessage.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(Alarm.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(SuspendedTask.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(RunningTask.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(Alarm.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(FailedTask.class, ExpectedMessage.RequiredFlag.OPTIONAL), new ExpectedMessage(CompletedTask.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(ClosedContext.class, ExpectedMessage.RequiredFlag.OPTIONAL), new ExpectedMessage(CompletedEvaluator.class, ExpectedMessage.RequiredFlag.REQUIRED), new ExpectedMessage(StopTime.class, ExpectedMessage.RequiredFlag.REQUIRED)};
    private final transient Class<?> failMsgClass;
    private final transient EvaluatorRequestor requestor;
    private final transient Clock clock;
    private transient RunningTask task = null;
    private transient int expectIdx = 0;
    private transient DriverState state = DriverState.INIT;

    @Inject
    public FailDriver(@Parameter(value=FailMsgClassName.class) String failMsgClassName, EvaluatorRequestor requestor, Clock clock) throws ClassNotFoundException {
        this.failMsgClass = ClassLoader.getSystemClassLoader().loadClass(failMsgClassName);
        this.requestor = requestor;
        this.clock = clock;
        this.checkMsgOrder(this);
    }

    private void checkMsgOrder(Object msg) throws SimulatedDriverFailure, DriverSideFailure {
        String msgClassName = msg.getClass().getName();
        LOG.log(Level.FINE, "At {0} {1}:{2}", new Object[]{this.state, this.expectIdx, msgClassName});
        if (this.state == DriverState.FAILED) {
            return;
        }
        if (this.failMsgClass.isInstance(msg)) {
            this.state = DriverState.FAILED;
        }
        boolean notFound = true;
        while (this.expectIdx < EVENT_SEQUENCE.length) {
            if (EVENT_SEQUENCE[this.expectIdx].msgClass.isInstance(msg)) {
                notFound = false;
                break;
            }
            if (EVENT_SEQUENCE[this.expectIdx].requiredFlag == ExpectedMessage.RequiredFlag.REQUIRED) break;
            ++this.expectIdx;
        }
        if (notFound) {
            LOG.log(Level.SEVERE, "Event out of sequence: {0} {1}:{2}", new Object[]{this.state, this.expectIdx, msgClassName});
            throw new DriverSideFailure("Event out of sequence: " + msgClassName);
        }
        LOG.log(Level.INFO, "{0}: send: {1} got: {2}", new Object[]{this.state, EVENT_SEQUENCE[this.expectIdx], msgClassName});
        ++this.expectIdx;
        if (this.state == DriverState.FAILED) {
            SimulatedDriverFailure ex = new SimulatedDriverFailure("Simulated Failure at FailDriver :: " + msgClassName);
            LOG.log(Level.INFO, "Simulated Failure: {0}", ex);
            throw ex;
        }
    }

    final class StopHandler
    implements EventHandler<StopTime> {
        StopHandler() {
        }

        public void onNext(StopTime time) {
            FailDriver.this.checkMsgOrder(time);
        }
    }

    final class AlarmHandler
    implements EventHandler<Alarm> {
        AlarmHandler() {
        }

        public void onNext(Alarm time) {
            FailDriver.this.checkMsgOrder(time);
            switch (FailDriver.this.state) {
                case SEND_MSG: {
                    FailDriver.this.task.send(HELLO_STR);
                    break;
                }
                case SUSPEND: {
                    FailDriver.this.task.suspend();
                    break;
                }
                case CLOSE: {
                    FailDriver.this.task.close();
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unexpected state at AlarmHandler: {0}", (Object)FailDriver.this.state);
                    throw new DriverSideFailure("Unexpected state: " + (Object)((Object)FailDriver.this.state));
                }
            }
        }
    }

    final class StartHandler
    implements EventHandler<StartTime> {
        StartHandler() {
        }

        public void onNext(StartTime time) {
            FailDriver.this.checkMsgOrder(time);
            FailDriver.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(128).setNumberOfCores(1).build());
        }
    }

    final class CompletedTaskHandler
    implements EventHandler<CompletedTask> {
        CompletedTaskHandler() {
        }

        public void onNext(CompletedTask task) {
            FailDriver.this.checkMsgOrder(task);
            task.getActiveContext().close();
        }
    }

    final class FailedTaskHandler
    implements EventHandler<FailedTask> {
        FailedTaskHandler() {
        }

        public void onNext(FailedTask task) {
            LOG.log(Level.WARNING, "Task failed: " + task.getId(), (Throwable)task.getReason().orElse(null));
            FailDriver.this.checkMsgOrder(task);
            if (task.getActiveContext().isPresent()) {
                ((ActiveContext)task.getActiveContext().get()).close();
            }
        }
    }

    final class TaskMessageHandler
    implements EventHandler<TaskMessage> {
        TaskMessageHandler() {
        }

        public void onNext(TaskMessage msg) {
            FailDriver.this.checkMsgOrder(msg);
            assert (Arrays.equals(HELLO_STR, msg.get()));
            assert (FailDriver.this.state == DriverState.SEND_MSG);
            FailDriver.this.state = DriverState.SUSPEND;
            FailDriver.this.clock.scheduleAlarm(1000, (EventHandler)new AlarmHandler());
        }
    }

    final class SuspendedTaskHandler
    implements EventHandler<SuspendedTask> {
        SuspendedTaskHandler() {
        }

        public void onNext(SuspendedTask task) {
            FailDriver.this.checkMsgOrder(task);
            FailDriver.this.state = DriverState.RESUME;
            try {
                task.getActiveContext().submitTask(TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, task.getId() + "_RESUMED").set((Impl)TaskConfiguration.TASK, NoopTask.class).set((Impl)TaskConfiguration.ON_MESSAGE, NoopTask.DriverMessageHandler.class).set((Impl)TaskConfiguration.ON_SUSPEND, NoopTask.TaskSuspendHandler.class).set((Impl)TaskConfiguration.ON_CLOSE, NoopTask.TaskCloseHandler.class).set((Impl)TaskConfiguration.ON_TASK_STOP, NoopTask.TaskStopHandler.class).set((Impl)TaskConfiguration.ON_SEND_MESSAGE, NoopTask.class).set((Param)TaskConfiguration.MEMENTO, DatatypeConverter.printBase64Binary((byte[])HELLO_STR)).build());
            }
            catch (BindException ex) {
                LOG.log(Level.SEVERE, "Task configuration error", ex);
                throw new DriverSideFailure("Task configuration error", ex);
            }
        }
    }

    final class RunningTaskHandler
    implements EventHandler<RunningTask> {
        RunningTaskHandler() {
        }

        public void onNext(RunningTask task) {
            FailDriver.this.checkMsgOrder(task);
            FailDriver.this.task = task;
            switch (FailDriver.this.state) {
                case INIT: {
                    FailDriver.this.state = DriverState.SEND_MSG;
                    break;
                }
                case RESUME: {
                    FailDriver.this.state = DriverState.CLOSE;
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Unexpected state at TaskRuntime: {0}", (Object)FailDriver.this.state);
                    throw new DriverSideFailure("Unexpected state: " + (Object)((Object)FailDriver.this.state));
                }
            }
            FailDriver.this.clock.scheduleAlarm(1000, (EventHandler)new AlarmHandler());
        }
    }

    final class FailedContextHandler
    implements EventHandler<FailedContext> {
        FailedContextHandler() {
        }

        public void onNext(FailedContext context) {
            LOG.log(Level.WARNING, "Context failed: " + context.getId(), (Throwable)context.getReason().orElse(null));
            FailDriver.this.checkMsgOrder(context);
        }
    }

    final class ClosedContextHandler
    implements EventHandler<ClosedContext> {
        ClosedContextHandler() {
        }

        public void onNext(ClosedContext context) {
            FailDriver.this.checkMsgOrder(context);
        }
    }

    final class ContextMessageHandler
    implements EventHandler<ContextMessage> {
        ContextMessageHandler() {
        }

        public void onNext(ContextMessage message) {
            FailDriver.this.checkMsgOrder(message);
        }
    }

    final class ActiveContextHandler
    implements EventHandler<ActiveContext> {
        ActiveContextHandler() {
        }

        public void onNext(ActiveContext context) {
            FailDriver.this.checkMsgOrder(context);
            try {
                context.submitTask(TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, "FailTask_" + context.getId()).set((Impl)TaskConfiguration.TASK, NoopTask.class).set((Impl)TaskConfiguration.ON_MESSAGE, NoopTask.DriverMessageHandler.class).set((Impl)TaskConfiguration.ON_SUSPEND, NoopTask.TaskSuspendHandler.class).set((Impl)TaskConfiguration.ON_CLOSE, NoopTask.TaskCloseHandler.class).set((Impl)TaskConfiguration.ON_TASK_STOP, NoopTask.TaskStopHandler.class).set((Impl)TaskConfiguration.ON_SEND_MESSAGE, NoopTask.class).build());
            }
            catch (BindException ex) {
                LOG.log(Level.WARNING, "Task configuration error", ex);
                throw new RuntimeException(ex);
            }
        }
    }

    final class FailedEvaluatorHandler
    implements EventHandler<FailedEvaluator> {
        FailedEvaluatorHandler() {
        }

        public void onNext(FailedEvaluator eval) {
            LOG.log(Level.WARNING, "Evaluator failed: " + eval.getId(), (Throwable)eval.getEvaluatorException());
            FailDriver.this.checkMsgOrder(eval);
            throw new RuntimeException((Throwable)eval.getEvaluatorException());
        }
    }

    final class CompletedEvaluatorHandler
    implements EventHandler<CompletedEvaluator> {
        CompletedEvaluatorHandler() {
        }

        public void onNext(CompletedEvaluator eval) {
            FailDriver.this.checkMsgOrder(eval);
        }
    }

    final class AllocatedEvaluatorHandler
    implements EventHandler<AllocatedEvaluator> {
        AllocatedEvaluatorHandler() {
        }

        public void onNext(AllocatedEvaluator eval) {
            FailDriver.this.checkMsgOrder(eval);
            try {
                eval.submitContext(ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "FailContext_" + eval.getId()).build());
            }
            catch (BindException ex) {
                LOG.log(Level.WARNING, "Context configuration error", ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public static final class ExpectedMessage {
        private final transient Class<?> msgClass;
        private final transient RequiredFlag requiredFlag;
        private final transient String repr;

        public ExpectedMessage(Class<?> clazz, RequiredFlag requiredFlag) {
            this.msgClass = clazz;
            this.requiredFlag = requiredFlag;
            this.repr = this.msgClass.getSimpleName() + ":" + (Object)((Object)this.requiredFlag);
        }

        public String toString() {
            return this.repr;
        }

        public static enum RequiredFlag {
            OPTIONAL,
            REQUIRED;

        }
    }

    @NamedParameter(doc="Full name of the message class to fail on", short_name="fail")
    public static final class FailMsgClassName
    implements Name<String> {
    }

    private static enum DriverState {
        INIT,
        SEND_MSG,
        SUSPEND,
        RESUME,
        CLOSE,
        FAILED;

    }
}

