/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.fail.driver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.driver.client.JobMessageObserver;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.evaluator.EvaluatorRequest;
import org.apache.reef.driver.evaluator.EvaluatorRequestor;
import org.apache.reef.driver.task.FailedTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.fail.task.FailTaskCall;
import org.apache.reef.tests.library.exceptions.SimulatedDriverFailure;
import org.apache.reef.wake.EventHandler;
import org.apache.reef.wake.time.event.StartTime;

@Unit
public final class DriverFailOnFail {
    private static final Logger LOG = Logger.getLogger(DriverFailOnFail.class.getName());
    private final transient JobMessageObserver client;
    private final transient EvaluatorRequestor requestor;

    @Inject
    public DriverFailOnFail(JobMessageObserver client, EvaluatorRequestor requestor) {
        this.client = client;
        this.requestor = requestor;
    }

    public final class StartHandler
    implements EventHandler<StartTime> {
        public void onNext(StartTime time) {
            LOG.log(Level.INFO, "StartTime: {0}", time);
            DriverFailOnFail.this.requestor.submit(EvaluatorRequest.newBuilder().setNumber(1).setMemory(128).setNumberOfCores(1).build());
        }
    }

    public final class FailedTaskHandler
    implements EventHandler<FailedTask> {
        public void onNext(FailedTask task) throws SimulatedDriverFailure {
            SimulatedDriverFailure error = new SimulatedDriverFailure("Simulated Failure at DriverFailOnFail :: " + task.getClass().getName(), task.asError());
            LOG.log(Level.INFO, "Simulated Failure: {0}", error);
            throw error;
        }
    }

    public final class AllocatedEvaluatorHandler
    implements EventHandler<AllocatedEvaluator> {
        public void onNext(AllocatedEvaluator eval) {
            try {
                LOG.log(Level.INFO, "Submit task: Fail2");
                Configuration contextConfig = ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "Fail2").build();
                Configuration taskConfig = TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, "Fail2").set((Impl)TaskConfiguration.TASK, FailTaskCall.class).build();
                eval.submitContextAndTask(contextConfig, taskConfig);
            }
            catch (BindException ex) {
                LOG.log(Level.WARNING, "Configuration error", ex);
                throw new RuntimeException(ex);
            }
        }
    }
}

