/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.tests.evaluatorreuse;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.bind.DatatypeConverter;
import org.apache.reef.driver.client.JobMessageObserver;
import org.apache.reef.driver.context.ActiveContext;
import org.apache.reef.driver.context.ContextConfiguration;
import org.apache.reef.driver.evaluator.AllocatedEvaluator;
import org.apache.reef.driver.task.CompletedTask;
import org.apache.reef.driver.task.TaskConfiguration;
import org.apache.reef.tang.annotations.Name;
import org.apache.reef.tang.annotations.NamedParameter;
import org.apache.reef.tang.annotations.Parameter;
import org.apache.reef.tang.annotations.Unit;
import org.apache.reef.tang.exceptions.BindException;
import org.apache.reef.tang.formats.Impl;
import org.apache.reef.tang.formats.Param;
import org.apache.reef.tests.library.exceptions.UnexpectedTaskReturnValue;
import org.apache.reef.tests.library.tasks.EchoTask;
import org.apache.reef.wake.EventHandler;

@Unit
final class EvaluatorReuseTestDriver {
    private static final Logger LOG = Logger.getLogger(EvaluatorReuseTestDriver.class.getName());
    private final int numberOfIterations;
    private final JobMessageObserver client;
    private int counter = 0;
    private String lastMessage = null;

    @Inject
    EvaluatorReuseTestDriver(@Parameter(value=NumberOfIterations.class) int n, JobMessageObserver client) {
        this.numberOfIterations = n;
        this.client = client;
    }

    private void startTask(ActiveContext context) {
        if (this.counter < this.numberOfIterations) {
            try {
                this.lastMessage = "ECHO-" + this.counter;
                this.client.sendMessageToClient(("Submitting iteration " + this.counter).getBytes());
                String memento = DatatypeConverter.printBase64Binary((byte[])this.lastMessage.getBytes());
                context.submitTask(TaskConfiguration.CONF.set((Param)TaskConfiguration.IDENTIFIER, this.lastMessage).set((Impl)TaskConfiguration.TASK, EchoTask.class).set((Param)TaskConfiguration.MEMENTO, memento).build());
                ++this.counter;
            }
            catch (BindException e) {
                context.close();
                throw new RuntimeException(e);
            }
        } else {
            this.client.sendMessageToClient("Done. Closing the Context".getBytes());
            context.close();
        }
    }

    final class ContextActiveHandler
    implements EventHandler<ActiveContext> {
        ContextActiveHandler() {
        }

        public void onNext(ActiveContext context) {
            EvaluatorReuseTestDriver.this.startTask(context);
        }
    }

    final class EvaluatorAllocatedHandler
    implements EventHandler<AllocatedEvaluator> {
        EvaluatorAllocatedHandler() {
        }

        public void onNext(AllocatedEvaluator eb) {
            LOG.log(Level.FINE, "AllocatedEvaluator: " + eb);
            try {
                eb.submitContext(ContextConfiguration.CONF.set((Param)ContextConfiguration.IDENTIFIER, "EvaluatorReuse").build());
            }
            catch (BindException e) {
                throw new RuntimeException(e);
            }
        }
    }

    final class TaskCompletedHandler
    implements EventHandler<CompletedTask> {
        TaskCompletedHandler() {
        }

        public void onNext(CompletedTask completed) {
            String returned = new String(completed.get());
            String msg = "CompletedTask returned: \"" + returned + "\"";
            EvaluatorReuseTestDriver.this.client.sendMessageToClient(msg.getBytes());
            if (!returned.equals(EvaluatorReuseTestDriver.this.lastMessage)) {
                throw new UnexpectedTaskReturnValue(EvaluatorReuseTestDriver.this.lastMessage, returned);
            }
            EvaluatorReuseTestDriver.this.startTask(completed.getActiveContext());
        }
    }

    @NamedParameter(default_value="3", short_name="i")
    class NumberOfIterations
    implements Name<Integer> {
        NumberOfIterations() {
        }
    }
}

